PSCAD 4.2.0

Settings
 {
 Id = "976141504.1144683814"
 Author = "jayas.jayas"
 Desc = "Parallel Transmission Line (Mid-line Fault)"
 Arch = "windows"
 Options = 0
 Build = 19
 Warn = 7
 Check = 15
 Libs = ""
 Source = ""
 RunInfo = 
  {
  Fin = 0.5
  Step = 5e-005
  Plot = 5e-005
  Chat = 0.001
  Brch = 0.0005
  Lat = 100
  Options = 0
  Advanced = 511
  Debug = 0
  StartFile = ""
  OFile = "noname.out"
  SFile = "noname.snp"
  SnapTime = 0.3
  Mruns = 10
  Mrunfile = 0
  StartType = 0
  PlotType = 0
  SnapType = 0
  MrunType = "mrun"
  }


Global_Consts = 
  {
  f = 60.0 [Hz]
  }

 }

Definitions
 {
 Module("Controls")
  {
  Desc = ""
  FileDate = 1144683530
  Nodes = 
   {
   Output("BRKR",36,-36)
    {
    Type = Integer
    Dim  = [4]
    }
   Input("Flt_en",36,18)
    {
    Type = Integer
    }
   Output("FLT",36,0)
    {
    Type = Integer
    }
   }

  Graphics = 
   {
   Brush(Solid,Yellow)
   Rectangle(-24,-43,27,30)
   Pen(Gray)
   Line(27,28,27,-43)
   Brush(,Silver)
   Rectangle(0,-13,3,0)
   Brush(,Gray)
   Rectangle(-3,-10,6,-7)
   Text(1,25,"Controls")
   Pen(Black)
   Line(27,18,36,18)
   Line(27,-36,36,-36)
   Line(27,0,36,0)
   Pen(ByNode)
   Brush(Hollow)
   Rectangle(-4,-18,7,3)
   }


  Page(B/A3,Landscape,16,[597,467],100)
   {
   0.datalabel([2016,378],3,0,-1)
    {
    Name = "B1T2"
    }
   0.datalabel([2016,432],3,0,-1)
    {
    Name = "B2T1"
    }
   0.datalabel([2016,486],3,0,-1)
    {
    Name = "B2T2"
    }
   -Wire-([720,720],0,0,-1)
    {
    Vertex="0,0;36,0"
    }
   0.datalabel([756,720],0,0,-1)
    {
    Name = "Tfs"
    }
   0.datalabel([756,756],0,0,-1)
    {
    Name = "Tfd"
    }
   -ControlPanel-([180,450],0)
    {
    Name = "SOURCE 2"
    Flags = 0
    State = 1
    Icon = -1,-1
    Posn = -1,-1
    Extents = 0,0,576,126
    Slider(38530248)
    Meter(38596424)
    Slider(38533104)
    Meter(38497632)
    Meter(38321248)
    Meter(38347304)
    Meter(38454032)
    Meter(38616688)
    }
   -Sticky-([684,198],0)
    {
    Name = "Untitled"
    Font = 1
    Bounds = 684,198,864,270
    Alignment = 0
    Style = 1
    Arrow = 0
    Color = 0,15792890
    Text = "\
Adjust phase angle to obtain
the correct power flow. Adjust
voltage to obtain the matching
VAR flow at each end."
    }
   0.arrow_a([684,270],1,0,-1)
    {
    }
   0.datalabel([2034,738],3,0,-1)
    {
    Name = "B3T1"
    }
   0.datalabel([2034,792],3,0,-1)
    {
    Name = "B3T2"
    }
   0.datalabel([2034,846],3,0,-1)
    {
    Name = "B4T1"
    }
   -Sticky-([1728,1008],0)
    {
    Name = ""
    Font = 1
    Bounds = 1728,1008,1836,1044
    Alignment = 0
    Style = 1
    Arrow = 0
    Color = 0,15792890
    Text = "Exports to Main Page"
    }
   0.datalabel([1800,1062],6,0,-1)
    {
    Name = "B1"
    }
   0.datalabel([1800,1080],6,0,-1)
    {
    Name = "B2"
    }
   0.datalabel([1800,1098],6,0,-1)
    {
    Name = "B3"
    }
   0.datalabel([1800,1116],6,0,-1)
    {
    Name = "B4"
    }
   -Sticky-([1728,180],0)
    {
    Name = ""
    Font = 1
    Bounds = 1728,180,1836,216
    Alignment = 0
    Style = 1
    Arrow = 0
    Color = 0,15792890
    Text = "BREAKER CONTROLS"
    }
   -Sticky-([2016,180],0)
    {
    Name = "Untitled"
    Font = 1
    Bounds = 2016,180,2178,252
    Alignment = 0
    Style = 1
    Arrow = 0
    Color = 0,15792890
    Text = "\
Adjust breaker clearing time (T1)
and reclose time (T2) if needed."
    }
   -Wire-([720,756],0,0,-1)
    {
    Vertex="0,0;36,0"
    }
   -ControlPanel-([1728,306],0)
    {
    Name = "B1 Timing"
    Flags = 0
    State = 1
    Icon = -1,-1
    Posn = -1,-1
    Extents = 0,0,216,126
    Switch(37729880)
    Slider(37705192)
    Slider(37558904)
    }
   -ControlPanel-([1728,450],0)
    {
    Name = "B2 Timing"
    Flags = 0
    State = 1
    Icon = -1,-1
    Posn = -1,-1
    Extents = 0,0,216,126
    Switch(37711088)
    Slider(37555888)
    Slider(37702704)
    }
   0.datalabel([2034,900],3,0,-1)
    {
    Name = "B4T2"
    }
   0.tbreakn([2106,324],4,0,20)
    {
    NUMS = "1"
    INIT = "0"
    TO1 = "B1T1"
    TO2 = "B1T2"
    }
   0.tbreakn([2106,918],4,0,180)
    {
    NUMS = "1"
    INIT = "0"
    TO1 = "B4T1"
    TO2 = "B4T2"
    }
   0.var([1980,432],0,37555888,50)
    {
    Name = "B2T1"
    Group = ""
    Display = "0"
    Max = "2.0"
    Min = "0.0"
    Value = "2.0"
    Units = ""
    Collect = "1"
    }
   0.var([1980,378],0,37558904,40)
    {
    Name = "B1T2"
    Group = ""
    Display = "0"
    Max = "2.0"
    Min = "0.0"
    Value = "2.0"
    Units = ""
    Collect = "1"
    }
   -ControlPanel-([1728,684],0)
    {
    Name = "B3 Timing"
    Flags = 0
    State = 1
    Icon = -1,-1
    Posn = -1,-1
    Extents = 0,0,216,126
    Switch(37725504)
    Slider(37722472)
    Slider(37719616)
    }
   -ControlPanel-([1728,828],0)
    {
    Name = "B4 Timing"
    Flags = 0
    State = 1
    Icon = -1,-1
    Posn = -1,-1
    Extents = 0,0,216,126
    Switch(37732520)
    Slider(37716760)
    Slider(37713904)
    }
   0.datalabel([2016,324],3,0,-1)
    {
    Name = "B1T1"
    }
   -Wire-([2142,360],0,0,-1)
    {
    Vertex="0,0;0,-36"
    }
   0.logic([2178,360],0,0,200)
    {
    Type = "1"
    Inv = "0"
    }
   -Wire-([2142,432],0,0,-1)
    {
    Vertex="0,0;0,-36"
    }
   -Wire-([2142,468],0,0,-1)
    {
    Vertex="0,0;0,54"
    }
   0.logic([2178,468],6,0,210)
    {
    Type = "1"
    Inv = "0"
    }
   -Wire-([2160,828],0,0,-1)
    {
    Vertex="0,0;0,-36"
    }
   -Wire-([2106,810],0,0,-1)
    {
    Vertex="0,0;54,0"
    }
   0.datalabel([2106,810],4,0,-1)
    {
    Name = "flt_en"
    }
   -Wire-([2160,738],0,0,-1)
    {
    Vertex="0,0;-18,0"
    }
   0.logic([2196,756],0,0,240)
    {
    Type = "1"
    Inv = "0"
    }
   -Wire-([2160,738],0,0,-1)
    {
    Vertex="0,0;0,18"
    }
   0.logic([2196,864],6,0,250)
    {
    Type = "1"
    Inv = "0"
    }
   -Wire-([2160,918],0,0,-1)
    {
    Vertex="0,0;-18,0"
    }
   -Wire-([2160,918],0,0,-1)
    {
    Vertex="0,0;0,-54"
    }
   0.tbreakn([2106,522],4,0,80)
    {
    NUMS = "1"
    INIT = "0"
    TO1 = "B2T1"
    TO2 = "B2T2"
    }
   0.datamerge([1818,1134],4,0,290)
    {
    N = "4"
    Type = "1"
    Disp = "1"
    }
   0.datalabel([1782,1206],4,0,-1)
    {
    Name = "Fault"
    }
   -Wire-([1782,1206],0,0,-1)
    {
    Vertex="0,0;54,0"
    }
   0.datalabel([882,738],4,0,-1)
    {
    Name = "Fault"
    }
   0.tbreakn([2106,738],4,0,130)
    {
    NUMS = "1"
    INIT = "0"
    TO1 = "B3T1"
    TO2 = "B3T2"
    }
   -Sticky-([180,666],0)
    {
    Name = ""
    Font = 1
    Bounds = 180,666,288,702
    Alignment = 0
    Style = 1
    Arrow = 0
    Color = 0,15792890
    Text = "FAULT CONTROLS"
    }
   -ControlPanel-([180,306],0)
    {
    Name = "SOURCE 1"
    Flags = 0
    State = 1
    Icon = -1,-1
    Posn = -1,-1
    Extents = 0,0,576,126
    Slider(38524616)
    Meter(38590320)
    Slider(38527392)
    Meter(38465408)
    Meter(38472088)
    Meter(38350400)
    Meter(38448040)
    Meter(38450952)
    }
   -Sticky-([180,252],0)
    {
    Name = ""
    Font = 1
    Bounds = 180,252,306,288
    Alignment = 0
    Style = 1
    Arrow = 0
    Color = 0,15792890
    Text = "PREFAULT CONTROLS"
    }
   -Sticky-([1224,162],0)
    {
    Name = ""
    Font = 1
    Bounds = 1224,162,1332,198
    Alignment = 0
    Style = 1
    Arrow = 0
    Color = 0,15792890
    Text = "Playback Recorders"
    }
   0.datalabel([2088,414],4,0,-1)
    {
    Name = "flt_en"
    }
   -ControlPanel-([180,720],0)
    {
    Name = "Fault Location and Type"
    Flags = 0
    State = 1
    Icon = -1,-1
    Posn = -1,-1
    Extents = 0,0,216,126
    Dial(38555192)
    Dial(38587424)
    }
   -ControlPanel-([414,720],0)
    {
    Name = "Start & Duration"
    Flags = 0
    State = 1
    Icon = -1,-1
    Posn = -1,-1
    Extents = 0,0,216,126
    Slider(37696040)
    Slider(37693208)
    Slider(38630632)
    }
   0.export([1854,1152],4,0,320)
    {
    Name = "BRKR"
    }
   0.export([1872,1206],4,0,300)
    {
    Name = "FLT"
    }
   0.tfaultn([846,738],4,0,230)
    {
    TF = "Tfs"
    DF = "Tfd"
    }
   0.import([1962,1080],0,0,190)
    {
    Name = "Flt_en"
    }
   0.var([684,756],0,37693208,100)
    {
    Name = "Duration "
    Group = ""
    Display = "0"
    Max = "1.0"
    Min = "0.0"
    Value = "0.26"
    Units = ""
    Collect = "1"
    }
   0.var([684,720],0,37696040,90)
    {
    Name = "Fault Start "
    Group = ""
    Display = "0"
    Max = "1.0"
    Min = "0.0"
    Value = "0.2"
    Units = "s"
    Collect = "1"
    }
   0.pgb([1818,1206],1,37698896,310)
    {
    Name = "<Untitled>"
    Group = ""
    Display = "0"
    Scale = "1.0"
    Units = ""
    mrun = "0"
    Pol = "0"
    Min = "-2.0"
    Max = "2.0"
    }
   -Wire-([2088,414],0,0,-1)
    {
    Vertex="0,0;54,0"
    }
   0.var([1980,486],0,37702704,60)
    {
    Name = "B2T2"
    Group = ""
    Display = "0"
    Max = "2.0"
    Min = "0.0"
    Value = "2.0"
    Units = ""
    Collect = "1"
    }
   0.var([1980,324],0,37705192,10)
    {
    Name = "B1T1"
    Group = ""
    Display = "0"
    Max = "2"
    Min = "0.0"
    Value = "2.0"
    Units = ""
    Collect = "1"
    }
   0.logic([2250,324],0,0,270)
    {
    Type = "2"
    Inv = "0"
    }
   0.datalabel([2286,324],6,0,-1)
    {
    Name = "B1"
    }
   0.datalabel([2286,504],4,0,-1)
    {
    Name = "B2"
    }
   0.datalabel([2304,900],4,0,-1)
    {
    Name = "B4"
    }
   0.var_switch([2178,504],0,37711088,70)
    {
    Name = "42 B2"
    Group = ""
    Display = "0"
    Value = "0"
    Max = "1"
    Min = "0"
    Ton = "ON"
    Toff = "OFF"
    }
   0.var([1998,900],0,37713904,160)
    {
    Name = "B4T2"
    Group = ""
    Display = "0"
    Max = "2.0"
    Min = "0.0"
    Value = "2.0"
    Units = "s"
    Collect = "1"
    }
   0.var([1998,846],0,37716760,150)
    {
    Name = "B4T1"
    Group = ""
    Display = "0"
    Max = "2.0"
    Min = "0.0"
    Value = "0.45"
    Units = "s"
    Collect = "1"
    }
   0.var([1998,792],0,37719616,140)
    {
    Name = "B3T2"
    Group = ""
    Display = "0"
    Max = "2.0"
    Min = "0.0"
    Value = "2.0"
    Units = "s"
    Collect = "1"
    }
   0.var([1998,738],0,37722472,110)
    {
    Name = "B3T1"
    Group = ""
    Display = "0"
    Max = "2"
    Min = "0.0"
    Value = "0.35"
    Units = "s"
    Collect = "1"
    }
   0.var_switch([2196,720],0,37725504,120)
    {
    Name = "42 B3"
    Group = ""
    Display = "0"
    Value = "0"
    Max = "1"
    Min = "0"
    Ton = "ON"
    Toff = "OFF"
    }
   0.datalabel([2304,720],2,0,-1)
    {
    Name = "B3"
    }
   0.logic([2250,504],6,0,220)
    {
    Type = "2"
    Inv = "0"
    }
   0.var_switch([2178,324],0,37729880,30)
    {
    Name = "42 B1"
    Group = ""
    Display = "0"
    Value = "0"
    Max = "1"
    Min = "0"
    Ton = "ON"
    Toff = "OFF"
    }
   0.var_switch([2196,900],0,37732520,170)
    {
    Name = "42 B4"
    Group = ""
    Display = "0"
    Value = "0"
    Max = "1"
    Min = "0"
    Ton = "ON"
    Toff = "OFF"
    }
   0.logic([2268,720],0,0,280)
    {
    Type = "2"
    Inv = "0"
    }
   -Sticky-([450,864],0)
    {
    Name = "Untitled"
    Font = 1
    Bounds = 450,864,594,1080
    Alignment = 0
    Style = 1
    Arrow = 0
    Color = 0,15792890
    Text = "\
Dial Position:
  1=> A-g
  2=> B-g
  3=> C-g
  4=> AB-g
  5=> AC-g
  6=> BC-g
  7=> ABC-g
  8=> AB 
  9=> AC 
10=> No Fault 
11=> No fault (0)"
    }
   -Sticky-([180,864],0)
    {
    Name = "Untitled"
    Font = 1
    Bounds = 180,864,432,1206
    Alignment = 0
    Style = 1
    Arrow = 0
    Color = 0,15792890
    Text = "\
Dial Position:
  1=> FT1:
          Between Source and  breakers 
          (B1 and B3)
  2=> FT2: 
          Between B1 and T1
  3=> FT3: 
          Between T1 and T2 (midpoint)
  4=> FT4: 
          Between T2 and B2
  5=> FT5:
          Between breakers (B3 and B4)
          and Source
  6=> FT6:
          Between T3 and B3
  7=> FT7:
          Between T3 and T4 (midpoint)
  8=> FT8:
          Between T4 and B4"
    }
   -Sticky-([684,810],0)
    {
    Name = ""
    Font = 1
    Bounds = 684,810,990,1134
    Alignment = 0
    Style = 1
    Arrow = 0
    Color = 0,15792890
    Text = "\
Example of a Test  Sequence 

Fault is located on Line 2 at B3 (Fault location 5)
Fault is 3 phase to Ground (Fault Type 7)

Fault occurs at 0.20 sec, Fault Duration 0.05 sec

Set Breakers:
B1T1 =  2.00:  Breaker B1 does not trip
B2T1 =  2.00:  Breaker B2 does not trip
B3T1 =  0.35:  Breaker B3 trips in 35 msec
B4T1 =  0.45:  Breaker B4 trips in 45 msec
B1T2 =  2.00:  Breaker B1 does not reclose
B2T2 =  2.00:  Breaker B2 does not reclose
B3T2 =  2.00:  Breaker B3 does not reclose
B4T2 =  2.00:  Breaker B4 does not reclose      

(Breaker  B1 and B2 do not automatically operate)
"
    }
   0.logic([2268,900],6,0,260)
    {
    Type = "2"
    Inv = "0"
    }
   -ControlPanel-([1224,216],0)
    {
    Name = "Recorders"
    Flags = 0
    State = 1
    Icon = -1,-1
    Posn = -1,-1
    Extents = 0,0,144,126
    Slider(38662040)
    Slider(38253608)
    }
   -ControlPanel-([1152,360],0)
    {
    Name = "Recorder Control"
    Flags = 0
    State = 1
    Icon = -1,-1
    Posn = -1,-1
    Extents = 0,0,288,126
    Switch(38668872)
    Switch(38671592)
    Switch(38674312)
    Switch(38677032)
    }
   -Sticky-([1170,504],0)
    {
    Name = ""
    Font = 1
    Bounds = 1170,504,1440,612
    Alignment = 0
    Style = 1
    Arrow = 0
    Color = 0,15792890
    Text = "\
To turn the Recorders on, click on the switch.
On = Recorder will record data.
Off = Recorder will NOT record data.

You can turn off and  on each recorder individually."
    }
   -Divider-([1584,990],0)
    {
    Size(774,0)
    3D = 1
    Color = 9
    Style = 0
    Weight = 2
    }
   -Divider-([144,648],0)
    {
    Size(1440,0)
    3D = 1
    Color = 9
    Style = 0
    Weight = 2
    }
   -Divider-([936,144],0)
    {
    Size(0,504)
    3D = 1
    Color = 9
    Style = 0
    Weight = 2
    }
   -Divider-([1584,144],0)
    {
    Size(0,1116)
    3D = 1
    Color = 9
    Style = 0
    Weight = 2
    }
   }
  }
 Module("Plots_B1")
  {
  Desc = ""
  FileDate = 0
  Nodes = 
   {
   }

  Graphics = 
   {
   Brush(Solid,Yellow)
   Rectangle(-24,-43,27,30)
   Line(-13,-1,-13,-21)
   Line(-18,-4,21,-4)
   Line(-13,-4,-4,-13)
   Line(-4,-13,1,-10)
   Line(6,-16,12,-13)
   Pen(Gray)
   Line(27,28,27,-43)
   Pen(Black)
   Line(1,-10,6,-16)
   Text(1,-28,"Plots")
   Text(3,24,"B1 B3")
   }


  Page(A/A4,Landscape,16,[597,467],100)
   {
   -Plot-([36,18],0)
    {
    Title = "Plots at B1"
    Draw = 1
    Area = [0,0,720,1170]
    Posn = [36,18]
    Icon = [-1,-1]
    Extents = 0,0,720,1170
    XLabel = ""
    AutoPan = "false,75"
    Graph([0,0],[0,0,720,282],"Voltage")
     {
     Options = 9
     Units = ""
     Curve(38462496,"V1a",0,,,)
     Curve(38297656,"V1b",1,,,)
     Curve(38278016,"V1c",2,,,)
     }
    Graph([0,282],[0,0,720,281],"Current")
     {
     Options = 9
     Units = ""
     Curve(38353312,"I1a",0,,,)
     Curve(38369640,"I1b",1,,,)
     Curve(38356224,"I1c",2,,,)
     }
    Graph([0,563],[0,0,720,281],"Current")
     {
     Options = 9
     Units = ""
     Curve(38359976,"I10",0,,,)
     }
    PGraph([0,844],[0,0,720,263],"PolyGraph")
     {
     Options = 2
     Curve(38622696,"Br1a",0,,,1)
     Curve(38300432,"Br1b",1,,,1)
     Curve(38341968,"Br1c",2,,,1)
     }
    }
   -Plot-([792,18],0)
    {
    Title = "Plots at B3"
    Draw = 1
    Area = [0,0,720,1170]
    Posn = [792,18]
    Icon = [-1,-1]
    Extents = 0,0,720,1170
    XLabel = ""
    AutoPan = "false,75"
    Graph([0,0],[0,0,720,282],"Voltage")
     {
     Options = 9
     Units = ""
     Curve(38404640,"V3a",0,,,)
     Curve(38407472,"V3b",1,,,)
     Curve(38410384,"V3c",2,,,)
     }
    Graph([0,282],[0,0,720,281],"Current")
     {
     Options = 9
     Units = ""
     Curve(38413296,"I3a",0,,,)
     Curve(38416208,"I3b",1,,,)
     Curve(38419120,"I3c",2,,,)
     }
    Graph([0,563],[0,0,720,281],"Current")
     {
     Options = 9
     Units = ""
     Curve(38422008,"I30",0,,,)
     }
    PGraph([0,844],[0,0,720,263],"PolyGraph")
     {
     Options = 2
     Curve(38439744,"Br3a",0,,,1)
     Curve(38442432,"Br3b",1,,,1)
     Curve(38445264,"Br3c",2,,,1)
     }
    }
   }
  }
 Module("Plots_B2")
  {
  Desc = ""
  FileDate = 0
  Nodes = 
   {
   }

  Graphics = 
   {
   Brush(Solid,Yellow)
   Rectangle(-24,-43,27,30)
   Line(-13,-1,-13,-21)
   Line(-13,-4,-4,-13)
   Line(-4,-13,1,-10)
   Line(6,-16,12,-13)
   Pen(Gray)
   Line(27,28,27,-43)
   Pen(Black)
   Line(1,-10,6,-16)
   Line(-18,-4,21,-4)
   Text(1,-28,"Plots")
   Text(3,24,"B2 B4")
   }


  Page(A/A4,Landscape,16,[597,467],100)
   {
   -Plot-([18,54],0)
    {
    Title = "Plots at B2"
    Draw = 1
    Area = [0,0,738,1116]
    Posn = [18,54]
    Icon = [-1,-1]
    Extents = 0,0,738,1116
    XLabel = ""
    AutoPan = "false,75"
    Graph([0,0],[0,0,738,268],"Voltage")
     {
     Options = 9
     Units = ""
     Curve(38281656,"V2a",0,,,)
     Curve(38284320,"V2b",1,,,)
     Curve(38311352,"V2c",2,,,)
     }
    Graph([0,268],[0,0,738,268],"Current")
     {
     Options = 9
     Units = ""
     Curve(38272272,"I2a",0,,,)
     Curve(38275104,"I2b",1,,,)
     Curve(38366560,"I2c",2,,,)
     }
    Graph([0,536],[0,0,738,268],"Current")
     {
     Options = 9
     Units = ""
     Curve(38363784,"I20",0,,,)
     }
    PGraph([0,804],[0,0,738,249],"PolyGraph")
     {
     Options = 2
     Curve(38291288,"Br2a",0,,,1)
     Curve(38303176,"Br2b",1,,,1)
     Curve(38293984,"Br2c",2,,,1)
     }
    }
   -Plot-([792,54],0)
    {
    Title = "Plots at B4"
    Draw = 1
    Area = [0,0,738,1116]
    Posn = [792,54]
    Icon = [-1,-1]
    Extents = 0,0,738,1116
    XLabel = ""
    AutoPan = "false,75"
    Graph([0,0],[0,0,738,268],"Voltage")
     {
     Options = 9
     Units = ""
     Curve(38619784,"V4a",0,,,)
     Curve(38425088,"V4b",1,,,)
     Curve(38469160,"V4c",2,,,)
     }
    Graph([0,268],[0,0,738,268],"Current")
     {
     Options = 9
     Units = ""
     Curve(38428000,"I4a",0,,,)
     Curve(38430912,"I4b",1,,,)
     Curve(38434000,"I4c",2,,,)
     }
    Graph([0,536],[0,0,738,268],"Current")
     {
     Options = 9
     Units = ""
     Curve(38436832,"I40",0,,,)
     }
    PGraph([0,804],[0,0,738,249],"PolyGraph")
     {
     Options = 2
     Curve(38223984,"Br4a",0,,,1)
     Curve(38456944,"Br4b",1,,,1)
     Curve(38459720,"Br4c",2,,,1)
     }
    }
   }
  }
 Module("Main")
  {
  Desc = "Main Page"
  FileDate = 1144683530
  Nodes = 
   {
   }

  Graphics = 
   {
   Rectangle(-18,-18,18,18)
   }


  Page(B/A3,Landscape,16,[597,467],100)
   {
   0.pgb([1800,1206],0,38223984,1120)
    {
    Name = "Br4a"
    Group = ""
    Display = "0"
    Scale = "1.0"
    Units = ""
    mrun = "0"
    Pol = "0"
    Min = "0.0"
    Max = "2.0"
    }
   0.datalabel([2016,126],2,0,-1)
    {
    Name = "I1A"
    }
   0.datalabel([2052,126],2,0,-1)
    {
    Name = "I1B"
    }
   0.datalabel([2088,126],2,0,-1)
    {
    Name = "I1C"
    }
   0.datalabel([2016,306],2,0,-1)
    {
    Name = "I2A"
    }
   0.datalabel([2052,306],2,0,-1)
    {
    Name = "I2B"
    }
   0.datalabel([2088,306],2,0,-1)
    {
    Name = "I2C"
    }
   -Wire-([1386,1170],0,0,-1)
    {
    Vertex="0,0;0,90"
    }
   0.datatap([1404,1206],0,0,330)
    {
    Index = "1"
    Dim = "1"
    Type = "2"
    Style = "0"
    Disp = "1"
    }
   0.datatap([1404,1242],0,0,420)
    {
    Index = "2"
    Dim = "1"
    Type = "2"
    Style = "0"
    Disp = "1"
    }
   0.datalabel([1908,126],2,0,-1)
    {
    Name = "V1A"
    }
   0.datalabel([1944,126],2,0,-1)
    {
    Name = "V1B"
    }
   0.datalabel([1980,126],2,0,-1)
    {
    Name = "V1C"
    }
   0.datalabel([1908,306],6,0,-1)
    {
    Name = "V2A"
    }
   0.datalabel([1944,306],6,0,-1)
    {
    Name = "V2B"
    }
   0.datalabel([1980,306],6,0,-1)
    {
    Name = "V2C"
    }
   -Wire-([1818,234],0,0,-1)
    {
    Vertex="0,0;54,0"
    }
   -Wire-([1764,1368],0,0,-1)
    {
    Vertex="0,0;36,0"
    }
   -Wire-([1764,1332],0,0,-1)
    {
    Vertex="0,0;36,0"
    }
   -Wire-([1764,1278],0,0,-1)
    {
    Vertex="0,0;36,0"
    }
   -Wire-([1764,1242],0,0,-1)
    {
    Vertex="0,0;36,0"
    }
   -Wire-([1548,1404],0,0,-1)
    {
    Vertex="0,0;36,0"
    }
   -Wire-([1548,1368],0,0,-1)
    {
    Vertex="0,0;36,0"
    }
   -Wire-([1548,1332],0,0,-1)
    {
    Vertex="0,0;36,0"
    }
   -Wire-([1422,1332],0,0,-1)
    {
    Vertex="0,0;36,0"
    }
   -Wire-([1422,1368],0,0,-1)
    {
    Vertex="0,0;36,0"
    }
   -Wire-([1422,1404],0,0,-1)
    {
    Vertex="0,0;36,0"
    }
   -Wire-([1638,1206],0,0,-1)
    {
    Vertex="0,0;36,0"
    }
   -Wire-([1638,1242],0,0,-1)
    {
    Vertex="0,0;36,0"
    }
   -Wire-([1638,1278],0,0,-1)
    {
    Vertex="0,0;36,0"
    }
   -Wire-([1638,1332],0,0,-1)
    {
    Vertex="0,0;36,0"
    }
   -Wire-([1638,1368],0,0,-1)
    {
    Vertex="0,0;36,0"
    }
   0.datatap([1530,1278],0,0,500)
    {
    Index = "3"
    Dim = "1"
    Type = "2"
    Style = "0"
    Disp = "1"
    }
   0.datatap([1530,1242],0,0,450)
    {
    Index = "2"
    Dim = "1"
    Type = "2"
    Style = "0"
    Disp = "1"
    }
   -Wire-([1530,1206],0,0,-1)
    {
    Vertex="0,0;54,0"
    }
   -Wire-([1530,1242],0,0,-1)
    {
    Vertex="0,0;54,0"
    }
   -Wire-([1530,1278],0,0,-1)
    {
    Vertex="0,0;54,0"
    }
   -Wire-([1404,1278],0,0,-1)
    {
    Vertex="0,0;54,0"
    }
   -Wire-([1404,1242],0,0,-1)
    {
    Vertex="0,0;54,0"
    }
   -Wire-([1404,1206],0,0,-1)
    {
    Vertex="0,0;54,0"
    }
   0.datatap([1404,1278],0,0,480)
    {
    Index = "3"
    Dim = "1"
    Type = "2"
    Style = "0"
    Disp = "1"
    }
   0.datatap([1530,1206],0,0,360)
    {
    Index = "1"
    Dim = "1"
    Type = "2"
    Style = "0"
    Disp = "1"
    }
   -Wire-([1512,1170],0,0,-1)
    {
    Vertex="0,0;0,90"
    }
   0.var([1782,234],0,38253608,30)
    {
    Name = "Stop"
    Group = ""
    Display = "0"
    Max = "1.0"
    Min = "0.0"
    Value = "0.5"
    Units = "s"
    Collect = "1"
    }
   -Wire-([1548,1440],0,0,-1)
    {
    Vertex="0,0;36,0"
    }
   -Wire-([1422,1440],0,0,-1)
    {
    Vertex="0,0;36,0"
    }
   -Wire-([684,738],0,0,-1)
    {
    Vertex="0,0;0,18"
    }
   -Wire-([198,630],0,0,-1)
    {
    Vertex="0,0;0,90"
    }
   0.datalabel([216,738],0,0,-1)
    {
    Name = "FT1"
    }
   0.pgb([1926,1260],0,38259304,520)
    {
    Name = "V3rms"
    Group = ""
    Display = "0"
    Scale = "1.0"
    Units = "kV"
    mrun = "0"
    Pol = "0"
    Min = "220"
    Max = "250"
    }
   0.datalabel([432,540],0,0,-1)
    {
    Name = "FT2"
    }
   -Wire-([414,738],0,0,-1)
    {
    Vertex="0,0;0,18"
    }
   0.breaker3([306,522],4,0,690)
    {
    Ctrl = "0"
    OPCUR = "0"
    ENAB = "0"
    CLVL = "0.0"
    View = "1"
    ViewB = "1"
    DisPQ = "1"
    NAME = "B1"
    NAMEA = "BRKA"
    NAMEB = "BRKB"
    NAMEC = "BRKC"
    ROFF = "1.0e6 [ohm]"
    RON = "0.1 [ohm]"
    PRER = "0.5 [ohm]"
    TDA = "0.0 [s]"
    TDB = "0.0 [s]"
    TDC = "0.0 [s]"
    TDRA = "0.05 [s]"
    TDRB = "0.05 [s]"
    TDRC = "0.05 [s]"
    PostIns = "0"
    TDBOA = "0.005"
    IBRA = "I1A"
    IBRB = "I1B"
    IBRC = "I1C"
    IBR0 = "I10"
    SBRA = "Br1A"
    SBRB = "Br1B"
    SBRC = "Br1C"
    BP = "P1"
    BQ = "Q1"
    BOpen1 = "0"
    BOpen2 = "0"
    BOpen3 = "0"
    P = "390.9 [MW]"
    Q = "179.4 [MVAR]"
    }
   -Wire-([378,522],0,0,-1)
    {
    Vertex="0,0;54,0"
    }
   -Wire-([1854,846],0,0,-1)
    {
    Vertex="0,0;18,0"
    }
   -Wire-([1854,414],0,0,-1)
    {
    Vertex="0,0;18,0"
    }
   -Wire-([1854,666],0,0,-1)
    {
    Vertex="0,0;18,0"
    }
   0.datalabel([936,1332],0,0,-1)
    {
    Name = "I1A"
    }
   0.datalabel([936,1368],0,0,-1)
    {
    Name = "I1B"
    }
   0.datalabel([936,1404],0,0,-1)
    {
    Name = "I1C"
    }
   0.datalabel([1062,1332],0,0,-1)
    {
    Name = "I2A"
    }
   0.datalabel([1062,1368],0,0,-1)
    {
    Name = "I2B"
    }
   0.pgb([1098,1332],0,38272272,1030)
    {
    Name = "I2a"
    Group = ""
    Display = "0"
    Scale = "1.0"
    Units = "kA"
    mrun = "0"
    Pol = "0"
    Min = "-6.0"
    Max = "6.0"
    }
   0.pgb([1098,1368],0,38275104,920)
    {
    Name = "I2b"
    Group = ""
    Display = "0"
    Scale = "1.0"
    Units = "kA"
    mrun = "0"
    Pol = "0"
    Min = "-6.0"
    Max = "6.0"
    }
   0.pgb([972,1278],0,38278016,390)
    {
    Name = "V1c"
    Group = ""
    Display = "0"
    Scale = "1.0"
    Units = "kV"
    mrun = "0"
    Pol = "0"
    Min = "-250.0"
    Max = "200.0"
    }
   0.pgb([1098,1206],0,38281656,280)
    {
    Name = "V2a"
    Group = ""
    Display = "0"
    Scale = "1.0"
    Units = "kV"
    mrun = "0"
    Pol = "0"
    Min = "-300.0"
    Max = "400.0"
    }
   0.pgb([1098,1242],0,38284320,340)
    {
    Name = "V2b"
    Group = ""
    Display = "0"
    Scale = "1.0"
    Units = "kV"
    mrun = "0"
    Pol = "0"
    Min = "-300.0"
    Max = "400.0"
    }
   0.datalabel([1170,1206],0,0,-1)
    {
    Name = "Br1A"
    }
   0.datalabel([1170,1242],0,0,-1)
    {
    Name = "Br1B"
    }
   0.datalabel([1170,1278],0,0,-1)
    {
    Name = "Br1C"
    }
   0.datalabel([1278,1206],0,0,-1)
    {
    Name = "Br2A"
    }
   0.datalabel([1278,1242],0,0,-1)
    {
    Name = "Br2B"
    }
   0.pgb([1314,1206],0,38291288,1160)
    {
    Name = "Br2a"
    Group = ""
    Display = "0"
    Scale = "1.0"
    Units = ""
    mrun = "0"
    Pol = "0"
    Min = "-0.1"
    Max = "0.1"
    }
   0.pgb([1314,1278],0,38293984,1090)
    {
    Name = "Br2c"
    Group = ""
    Display = "0"
    Scale = "1.0"
    Units = ""
    mrun = "0"
    Pol = "0"
    Min = "-0.1"
    Max = "0.1"
    }
   0.datalabel([1170,1332],0,0,-1)
    {
    Name = "P1"
    }
   0.pgb([972,1242],0,38297656,310)
    {
    Name = "V1b"
    Group = ""
    Display = "0"
    Scale = "1.0"
    Units = "kV"
    mrun = "0"
    Pol = "0"
    Min = "-250.0"
    Max = "200.0"
    }
   0.pgb([1206,1242],0,38300432,1150)
    {
    Name = "Br1b"
    Group = ""
    Display = "0"
    Scale = "1.0"
    Units = ""
    mrun = "0"
    Pol = "0"
    Min = "-0.1"
    Max = "0.1"
    }
   0.pgb([1314,1242],0,38303176,1140)
    {
    Name = "Br2b"
    Group = ""
    Display = "0"
    Scale = "1.0"
    Units = ""
    mrun = "0"
    Pol = "0"
    Min = "-0.1"
    Max = "0.1"
    }
   0.datatap([918,1206],0,0,230)
    {
    Index = "1"
    Dim = "1"
    Type = "2"
    Style = "0"
    Disp = "1"
    }
   0.datatap([918,1242],0,0,300)
    {
    Index = "2"
    Dim = "1"
    Type = "2"
    Style = "0"
    Disp = "1"
    }
   0.datalabel([900,1170],2,0,-1)
    {
    Name = "V1"
    }
   0.datalabel([936,1206],2,0,-1)
    {
    Name = "V1A"
    }
   0.datalabel([936,1242],2,0,-1)
    {
    Name = "V1B"
    }
   0.datalabel([1062,1242],2,0,-1)
    {
    Name = "V2B"
    }
   0.pgb([1098,1278],0,38311352,430)
    {
    Name = "V2c"
    Group = ""
    Display = "0"
    Scale = "1.0"
    Units = "kV"
    mrun = "0"
    Pol = "0"
    Min = "-300.0"
    Max = "400.0"
    }
   -Wire-([1170,1404],0,0,-1)
    {
    Vertex="0,0;36,0"
    }
   0.datalabel([1170,1404],0,0,-1)
    {
    Name = "S1W"
    }
   -Wire-([1170,1440],0,0,-1)
    {
    Vertex="0,0;36,0"
    }
   0.datalabel([1170,1440],0,0,-1)
    {
    Name = "S1Q"
    }
   -Wire-([1278,1404],0,0,-1)
    {
    Vertex="0,0;36,0"
    }
   -Wire-([1278,1440],0,0,-1)
    {
    Vertex="0,0;36,0"
    }
   0.datalabel([1278,1440],0,0,-1)
    {
    Name = "S2Q"
    }
   0.datalabel([1062,1206],2,0,-1)
    {
    Name = "V2A"
    }
   0.pgb([1314,1332],0,38321248,940)
    {
    Name = "P2"
    Group = ""
    Display = "0"
    Scale = "1.0"
    Units = "MW"
    mrun = "0"
    Pol = "0"
    Min = "-150"
    Max = "150"
    }
   0.datalabel([1278,1404],0,0,-1)
    {
    Name = "S2W"
    }
   -Wire-([1278,1368],0,0,-1)
    {
    Vertex="0,0;36,0"
    }
   0.datalabel([1278,1368],0,0,-1)
    {
    Name = "Q2"
    }
   -Wire-([1278,1332],0,0,-1)
    {
    Vertex="0,0;36,0"
    }
   0.datalabel([1278,1332],0,0,-1)
    {
    Name = "P2"
    }
   -Wire-([1278,1278],0,0,-1)
    {
    Vertex="0,0;36,0"
    }
   -Wire-([1278,1242],0,0,-1)
    {
    Vertex="0,0;36,0"
    }
   -Wire-([1278,1206],0,0,-1)
    {
    Vertex="0,0;36,0"
    }
   0.datalabel([1278,1278],0,0,-1)
    {
    Name = "Br2C"
    }
   0.datalabel([1062,1404],0,0,-1)
    {
    Name = "I2C"
    }
   -Wire-([1062,1404],0,0,-1)
    {
    Vertex="0,0;36,0"
    }
   -Wire-([1062,1368],0,0,-1)
    {
    Vertex="0,0;36,0"
    }
   -Wire-([1062,1332],0,0,-1)
    {
    Vertex="0,0;36,0"
    }
   -Wire-([936,1332],0,0,-1)
    {
    Vertex="0,0;36,0"
    }
   -Wire-([936,1368],0,0,-1)
    {
    Vertex="0,0;36,0"
    }
   -Wire-([936,1404],0,0,-1)
    {
    Vertex="0,0;36,0"
    }
   -Wire-([1170,1206],0,0,-1)
    {
    Vertex="0,0;36,0"
    }
   -Wire-([1170,1242],0,0,-1)
    {
    Vertex="0,0;36,0"
    }
   -Wire-([1170,1278],0,0,-1)
    {
    Vertex="0,0;36,0"
    }
   -Wire-([1170,1332],0,0,-1)
    {
    Vertex="0,0;36,0"
    }
   -Wire-([1170,1368],0,0,-1)
    {
    Vertex="0,0;36,0"
    }
   0.datalabel([1062,1278],2,0,-1)
    {
    Name = "V2C"
    }
   0.datatap([1044,1278],0,0,410)
    {
    Index = "3"
    Dim = "1"
    Type = "2"
    Style = "0"
    Disp = "1"
    }
   0.datatap([1044,1242],0,0,320)
    {
    Index = "2"
    Dim = "1"
    Type = "2"
    Style = "0"
    Disp = "1"
    }
   -Wire-([1044,1206],0,0,-1)
    {
    Vertex="0,0;54,0"
    }
   -Wire-([1044,1242],0,0,-1)
    {
    Vertex="0,0;54,0"
    }
   -Wire-([1044,1278],0,0,-1)
    {
    Vertex="0,0;54,0"
    }
   0.datalabel([936,1278],2,0,-1)
    {
    Name = "V1C"
    }
   -Wire-([918,1278],0,0,-1)
    {
    Vertex="0,0;54,0"
    }
   -Wire-([918,1242],0,0,-1)
    {
    Vertex="0,0;54,0"
    }
   -Wire-([918,1206],0,0,-1)
    {
    Vertex="0,0;54,0"
    }
   0.datatap([918,1278],0,0,380)
    {
    Index = "3"
    Dim = "1"
    Type = "2"
    Style = "0"
    Disp = "1"
    }
   0.datalabel([1170,1368],0,0,-1)
    {
    Name = "Q1"
    }
   0.pgb([1206,1278],0,38341968,1110)
    {
    Name = "Br1c"
    Group = ""
    Display = "0"
    Scale = "1.0"
    Units = ""
    mrun = "0"
    Pol = "0"
    Min = "-0.1"
    Max = "0.1"
    }
   0.datatap([1044,1206],0,0,260)
    {
    Index = "1"
    Dim = "1"
    Type = "2"
    Style = "0"
    Disp = "1"
    }
   0.datalabel([1026,1170],2,0,-1)
    {
    Name = "V2"
    }
   -Wire-([1026,1170],0,0,-1)
    {
    Vertex="0,0;0,90"
    }
   0.pgb([1314,1368],0,38347304,880)
    {
    Name = "Q2"
    Group = ""
    Display = "0"
    Scale = "1.0"
    Units = "MVAR"
    mrun = "0"
    Pol = "0"
    Min = "-50"
    Max = "50"
    }
   0.pgb([1206,1368],0,38350400,900)
    {
    Name = "Q1"
    Group = ""
    Display = "0"
    Scale = "1.0"
    Units = "MVAR"
    mrun = "0"
    Pol = "0"
    Min = "-50"
    Max = "50"
    }
   0.pgb([972,1332],0,38353312,1070)
    {
    Name = "I1a"
    Group = ""
    Display = "0"
    Scale = "1.0"
    Units = "kA"
    mrun = "0"
    Pol = "0"
    Min = "-6.0"
    Max = "6.0"
    }
   0.pgb([972,1404],0,38356224,860)
    {
    Name = "I1c"
    Group = ""
    Display = "0"
    Scale = "1.0"
    Units = "kA"
    mrun = "0"
    Pol = "0"
    Min = "-6.0"
    Max = "6.0"
    }
   -Wire-([1062,1440],0,0,-1)
    {
    Vertex="0,0;36,0"
    }
   -Wire-([936,1440],0,0,-1)
    {
    Vertex="0,0;36,0"
    }
   0.pgb([972,1440],0,38359976,780)
    {
    Name = "I10"
    Group = ""
    Display = "0"
    Scale = "1.0"
    Units = "kA"
    mrun = "0"
    Pol = "0"
    Min = "-0.2"
    Max = "0.6"
    }
   0.datalabel([1062,1440],0,0,-1)
    {
    Name = "I20"
    }
   0.pgb([1098,1440],0,38363784,760)
    {
    Name = "I20"
    Group = ""
    Display = "0"
    Scale = "1.0"
    Units = "kA"
    mrun = "0"
    Pol = "0"
    Min = "-0.6"
    Max = "0.1"
    }
   0.pgb([1098,1404],0,38366560,840)
    {
    Name = "I2c"
    Group = ""
    Display = "0"
    Scale = "1.0"
    Units = "kA"
    mrun = "0"
    Pol = "0"
    Min = "-6.0"
    Max = "6.0"
    }
   0.pgb([972,1368],0,38369640,930)
    {
    Name = "I1b"
    Group = ""
    Display = "0"
    Scale = "1.0"
    Units = "kA"
    mrun = "0"
    Pol = "0"
    Min = "-6.0"
    Max = "6.0"
    }
   -Wire-([900,1170],0,0,-1)
    {
    Vertex="0,0;0,90"
    }
   0.datalabel([936,1440],0,0,-1)
    {
    Name = "I10"
    }
   0.datalabel([1386,1170],2,0,-1)
    {
    Name = "V3"
    }
   0.datalabel([1422,1206],2,0,-1)
    {
    Name = "V3A"
    }
   0.datalabel([1422,1242],2,0,-1)
    {
    Name = "V3B"
    }
   0.datalabel([1422,1278],2,0,-1)
    {
    Name = "V3C"
    }
   0.datalabel([1548,1206],2,0,-1)
    {
    Name = "V4A"
    }
   0.datalabel([1548,1242],2,0,-1)
    {
    Name = "V4B"
    }
   0.datalabel([1548,1278],2,0,-1)
    {
    Name = "V4C"
    }
   0.datalabel([1908,558],2,0,-1)
    {
    Name = "V3A"
    }
   0.datalabel([1944,558],2,0,-1)
    {
    Name = "V3B"
    }
   0.datalabel([1980,558],2,0,-1)
    {
    Name = "V3C"
    }
   0.datalabel([1908,738],6,0,-1)
    {
    Name = "V4A"
    }
   0.datalabel([1944,738],6,0,-1)
    {
    Name = "V4B"
    }
   0.datalabel([1980,738],6,0,-1)
    {
    Name = "V4C"
    }
   0.datalabel([1422,1332],0,0,-1)
    {
    Name = "I3A"
    }
   0.datalabel([1422,1368],0,0,-1)
    {
    Name = "I3B"
    }
   0.datalabel([1422,1404],0,0,-1)
    {
    Name = "I3C"
    }
   0.datalabel([1422,1440],0,0,-1)
    {
    Name = "I30"
    }
   0.datalabel([1548,1332],0,0,-1)
    {
    Name = "I4A"
    }
   0.datalabel([1548,1368],0,0,-1)
    {
    Name = "I4B"
    }
   0.datalabel([1548,1404],0,0,-1)
    {
    Name = "I4C"
    }
   0.datalabel([1548,1440],0,0,-1)
    {
    Name = "I40"
    }
   0.datalabel([2016,558],2,0,-1)
    {
    Name = "I3A"
    }
   0.datalabel([2052,558],2,0,-1)
    {
    Name = "I3B"
    }
   0.datalabel([2088,558],2,0,-1)
    {
    Name = "I3C"
    }
   0.datalabel([2016,738],2,0,-1)
    {
    Name = "I4A"
    }
   0.datalabel([2052,738],2,0,-1)
    {
    Name = "I4B"
    }
   0.datalabel([2088,738],2,0,-1)
    {
    Name = "I4C"
    }
   0.datalabel([2088,270],0,0,-1)
    {
    Name = "Fault"
    }
   0.datalabel([2088,450],0,0,-1)
    {
    Name = "Fault"
    }
   0.datalabel([1638,1332],0,0,-1)
    {
    Name = "P3"
    }
   0.datalabel([1638,1368],0,0,-1)
    {
    Name = "Q3"
    }
   0.datalabel([1638,1206],0,0,-1)
    {
    Name = "Br3A"
    }
   0.datalabel([1638,1242],0,0,-1)
    {
    Name = "Br3B"
    }
   0.datalabel([1638,1278],0,0,-1)
    {
    Name = "Br3C"
    }
   -Wire-([1764,1206],0,0,-1)
    {
    Vertex="0,0;36,0"
    }
   0.datalabel([1764,1206],0,0,-1)
    {
    Name = "Br4A"
    }
   0.datalabel([1764,1242],0,0,-1)
    {
    Name = "Br4B"
    }
   0.datalabel([1764,1278],0,0,-1)
    {
    Name = "Br4C"
    }
   0.datalabel([1764,1332],0,0,-1)
    {
    Name = "P4"
    }
   0.datalabel([1764,1368],0,0,-1)
    {
    Name = "Q4"
    }
   0.pgb([1458,1206],0,38404640,350)
    {
    Name = "V3a"
    Group = ""
    Display = "0"
    Scale = "1.0"
    Units = "kV"
    mrun = "0"
    Pol = "0"
    Min = "-200.0"
    Max = "200.0"
    }
   0.pgb([1458,1242],0,38407472,440)
    {
    Name = "V3b"
    Group = ""
    Display = "0"
    Scale = "1.0"
    Units = "kV"
    mrun = "0"
    Pol = "0"
    Min = "-200.0"
    Max = "200.0"
    }
   0.pgb([1458,1278],0,38410384,490)
    {
    Name = "V3c"
    Group = ""
    Display = "0"
    Scale = "1.0"
    Units = "kV"
    mrun = "0"
    Pol = "0"
    Min = "-200.0"
    Max = "200.0"
    }
   0.pgb([1458,1332],0,38413296,910)
    {
    Name = "I3a"
    Group = ""
    Display = "0"
    Scale = "1.0"
    Units = "kA"
    mrun = "0"
    Pol = "0"
    Min = "-6.0"
    Max = "6.0"
    }
   0.pgb([1458,1368],0,38416208,830)
    {
    Name = "I3b"
    Group = ""
    Display = "0"
    Scale = "1.0"
    Units = "kA"
    mrun = "0"
    Pol = "0"
    Min = "-6.0"
    Max = "6.0"
    }
   0.pgb([1458,1404],0,38419120,750)
    {
    Name = "I3c"
    Group = ""
    Display = "0"
    Scale = "1.0"
    Units = "kA"
    mrun = "0"
    Pol = "0"
    Min = "-6.0"
    Max = "6.0"
    }
   0.pgb([1458,1440],0,38422008,710)
    {
    Name = "I30"
    Group = ""
    Display = "0"
    Scale = "1.0"
    Units = "kA"
    mrun = "0"
    Pol = "0"
    Min = "-0.45"
    Max = "0.05"
    }
   0.pgb([1584,1242],0,38425088,460)
    {
    Name = "V4b"
    Group = ""
    Display = "0"
    Scale = "1.0"
    Units = "kV"
    mrun = "0"
    Pol = "0"
    Min = "-200.0"
    Max = "200.0"
    }
   0.pgb([1584,1332],0,38428000,890)
    {
    Name = "I4a"
    Group = ""
    Display = "0"
    Scale = "1.0"
    Units = "kA"
    mrun = "0"
    Pol = "0"
    Min = "-6.0"
    Max = "6.0"
    }
   0.pgb([1584,1368],0,38430912,810)
    {
    Name = "I4b"
    Group = ""
    Display = "0"
    Scale = "1.0"
    Units = "kA"
    mrun = "0"
    Pol = "0"
    Min = "-6.0"
    Max = "6.0"
    }
   0.pgb([1584,1404],0,38434000,730)
    {
    Name = "I4c"
    Group = ""
    Display = "0"
    Scale = "1.0"
    Units = "kA"
    mrun = "0"
    Pol = "0"
    Min = "-6.0"
    Max = "6.0"
    }
   0.pgb([1584,1440],0,38436832,700)
    {
    Name = "I40"
    Group = ""
    Display = "0"
    Scale = "1.0"
    Units = "kA"
    mrun = "0"
    Pol = "0"
    Min = "-0.1"
    Max = "0.5"
    }
   0.pgb([1674,1206],0,38439744,1130)
    {
    Name = "Br3a"
    Group = ""
    Display = "0"
    Scale = "1.0"
    Units = ""
    mrun = "0"
    Pol = "0"
    Min = "0.0"
    Max = "2.0"
    }
   0.pgb([1674,1242],0,38442432,1100)
    {
    Name = "Br3b"
    Group = ""
    Display = "0"
    Scale = "1.0"
    Units = ""
    mrun = "0"
    Pol = "0"
    Min = "0.0"
    Max = "2.0"
    }
   0.pgb([1674,1278],0,38445264,1010)
    {
    Name = "Br3c"
    Group = ""
    Display = "0"
    Scale = "1.0"
    Units = ""
    mrun = "0"
    Pol = "0"
    Min = "0.0"
    Max = "2.0"
    }
   0.pgb([1674,1332],0,38448040,870)
    {
    Name = "P3"
    Group = ""
    Display = "0"
    Scale = "1.0"
    Units = "MW"
    mrun = "0"
    Pol = "0"
    Min = "-150"
    Max = "150"
    }
   0.pgb([1674,1368],0,38450952,800)
    {
    Name = "Q3"
    Group = ""
    Display = "0"
    Scale = "1.0"
    Units = "MVAR"
    mrun = "0"
    Pol = "0"
    Min = "-50"
    Max = "50"
    }
   0.pgb([1800,1332],0,38454032,850)
    {
    Name = "P4"
    Group = ""
    Display = "0"
    Scale = "1.0"
    Units = "MW"
    mrun = "0"
    Pol = "0"
    Min = "-150"
    Max = "150"
    }
   0.pgb([1800,1242],0,38456944,1080)
    {
    Name = "Br4b"
    Group = ""
    Display = "0"
    Scale = "1.0"
    Units = ""
    mrun = "0"
    Pol = "0"
    Min = "0.0"
    Max = "2.0"
    }
   0.pgb([1800,1278],0,38459720,960)
    {
    Name = "Br4c"
    Group = ""
    Display = "0"
    Scale = "1.0"
    Units = ""
    mrun = "0"
    Pol = "0"
    Min = "0.0"
    Max = "2.0"
    }
   0.pgb([972,1206],0,38462496,240)
    {
    Name = "V1a"
    Group = ""
    Display = "0"
    Scale = "1.0"
    Units = "kV"
    mrun = "0"
    Pol = "0"
    Min = "-250.0"
    Max = "200.0"
    }
   0.pgb([1926,1188],0,38465408,400)
    {
    Name = "V1rms"
    Group = ""
    Display = "0"
    Scale = "1.0"
    Units = "kV"
    mrun = "0"
    Pol = "0"
    Min = "220"
    Max = "250"
    }
   -Wire-([270,630],0,0,-1)
    {
    Vertex="0,0;-144,0"
    }
   -Wire-([882,630],0,0,-1)
    {
    Vertex="0,0;0,90"
    }
   0.pgb([1584,1278],0,38469160,510)
    {
    Name = "V4c"
    Group = ""
    Display = "0"
    Scale = "1.0"
    Units = "kV"
    mrun = "0"
    Pol = "0"
    Min = "-200.0"
    Max = "200.0"
    }
   0.pgb([1206,1332],0,38472088,980)
    {
    Name = "P1"
    Group = ""
    Display = "0"
    Scale = "1.0"
    Units = "MW"
    mrun = "0"
    Pol = "0"
    Min = "-150"
    Max = "150"
    }
   0.recorder2_0([1980,630],0,0,1280)
    {
    FName = "stn3"
    FFMT = "2"
    Rstep = "50"
    Mfilter = "0"
    FREQ = "1"
    StnN = "EMTDC_Simulation"
    DevNo = "3"
    NChA = "6"
    NChD = "1"
    ABFMT = "0"
    MFILE = "0"
    NxHdr = "0"
    AMin = "0"
    AMax = "4096"
    ENTCAP = "0"
    Hdr1 = "Extra_Line_1"
    Hdr2 = "Extra_Line_2"
    Hdr3 = "Extra_Line_3"
    Hdr4 = "Extra_Line_4"
    Hdr5 = "Extra_Line_5"
    NA1 = "V1a"
    DA1 = "A1"
    VS1 = "0"
    VT1 = "0"
    UN1 = "A1"
    PH1 = "0"
    TR1 = "1"
    CT1 = "A1"
    NA2 = "V1b"
    DA2 = "A2"
    VS2 = "0"
    VT2 = "0"
    UN2 = "A2"
    PH2 = "0"
    TR2 = "1"
    CT2 = "A2"
    NA3 = "V1c"
    DA3 = "A3"
    VS3 = "0"
    VT3 = "0"
    UN3 = "A3"
    PH3 = "0"
    TR3 = "1"
    CT3 = "A3"
    NA4 = "I1a"
    DA4 = "A4"
    VS4 = "0"
    VT4 = "1"
    UN4 = "A4"
    PH4 = "0"
    TR4 = "1"
    CT4 = "A4"
    NA5 = "I1b"
    DA5 = "A5"
    VS5 = "0"
    VT5 = "1"
    UN5 = "A5"
    PH5 = "0"
    TR5 = "1"
    CT5 = "A5"
    NA6 = "I1c"
    DA6 = "A6"
    VS6 = "0"
    VT6 = "1"
    UN6 = "A6"
    PH6 = "0"
    TR6 = "1"
    CT6 = "A6"
    NA7 = "A7"
    DA7 = "A7"
    VS7 = "0"
    VT7 = "0"
    UN7 = "A7"
    PH7 = "0"
    TR7 = "1"
    CT7 = "A7"
    NA8 = "A8"
    DA8 = "A8"
    VS8 = "0"
    VT8 = "0"
    UN8 = "A8"
    PH8 = "0"
    TR8 = "1"
    CT8 = "A8"
    NA9 = "A9"
    DA9 = "A9"
    VS9 = "0"
    VT9 = "0"
    UN9 = "A9"
    PH9 = "0"
    TR9 = "1"
    CT9 = "A9"
    NA10 = "A10"
    DA10 = "A10"
    VS10 = "0"
    VT10 = "0"
    UN10 = "A10"
    PH10 = "0"
    TR10 = "1"
    CT10 = "A10"
    NA11 = "A11"
    DA11 = "A11"
    VS11 = "0"
    VT11 = "0"
    UN11 = "A11"
    PH11 = "0"
    TR11 = "1"
    CT11 = "A11"
    NA12 = "A12"
    DA12 = "A12"
    VS12 = "0"
    VT12 = "0"
    UN12 = "A12"
    PH12 = "0"
    TR12 = "1.0"
    CT12 = "A12"
    ND1 = "D1"
    DD1 = "D1"
    NT1 = "0"
    ND2 = "D2"
    DD2 = "D2"
    NT2 = "0"
    ND3 = "D3"
    DD3 = "D3"
    NT3 = "0"
    ND4 = "D4"
    DD4 = "D4"
    NT4 = "0"
    ND5 = "D5"
    DD5 = "D5"
    NT5 = "0"
    ND6 = "D6"
    DD6 = "D6"
    NT6 = "0"
    ND7 = "D7"
    DD7 = "D7"
    NT7 = "0"
    ND8 = "D8"
    DD8 = "D8"
    NT8 = "0"
    ND9 = "D9"
    DD9 = "D9"
    NT9 = "0"
    ND10 = "D10"
    DD10 = "D10"
    NT10 = "0"
    ND11 = "D11"
    DD11 = "D11"
    NT11 = "0"
    ND12 = "D12"
    DD12 = "D12"
    NT12 = "0"
    ND13 = "D13"
    DD13 = "D13"
    NT13 = "0"
    ND14 = "D14"
    DD14 = "D14"
    NT14 = "0"
    ND15 = "D15"
    DD15 = "D15"
    NT15 = "0"
    ND16 = "D16"
    DD16 = "D16"
    NT16 = "0"
    }
   0.recorder2_0([1980,378],0,0,1360)
    {
    FName = "stn2"
    FFMT = "2"
    Rstep = "50"
    Mfilter = "0"
    FREQ = "1"
    StnN = "EMTDC_Simulation"
    DevNo = "2"
    NChA = "6"
    NChD = "1"
    ABFMT = "0"
    MFILE = "0"
    NxHdr = "0"
    AMin = "0"
    AMax = "4096"
    ENTCAP = "0"
    Hdr1 = "Extra_Line_1"
    Hdr2 = "Extra_Line_2"
    Hdr3 = "Extra_Line_3"
    Hdr4 = "Extra_Line_4"
    Hdr5 = "Extra_Line_5"
    NA1 = "V2a"
    DA1 = "A1"
    VS1 = "0"
    VT1 = "0"
    UN1 = "A1"
    PH1 = "0"
    TR1 = "1"
    CT1 = "A1"
    NA2 = "V2b"
    DA2 = "A2"
    VS2 = "0"
    VT2 = "0"
    UN2 = "A2"
    PH2 = "0"
    TR2 = "1"
    CT2 = "A2"
    NA3 = "V2c"
    DA3 = "A3"
    VS3 = "0"
    VT3 = "0"
    UN3 = "A3"
    PH3 = "0"
    TR3 = "1"
    CT3 = "A3"
    NA4 = "I2a"
    DA4 = "A4"
    VS4 = "0"
    VT4 = "1"
    UN4 = "A4"
    PH4 = "0"
    TR4 = "1"
    CT4 = "A4"
    NA5 = "I2b"
    DA5 = "A5"
    VS5 = "0"
    VT5 = "1"
    UN5 = "A5"
    PH5 = "0"
    TR5 = "1"
    CT5 = "A5"
    NA6 = "I2c"
    DA6 = "A6"
    VS6 = "0"
    VT6 = "1"
    UN6 = "A6"
    PH6 = "0"
    TR6 = "1"
    CT6 = "A6"
    NA7 = "A7"
    DA7 = "A7"
    VS7 = "0"
    VT7 = "0"
    UN7 = "A7"
    PH7 = "0"
    TR7 = "1"
    CT7 = "A7"
    NA8 = "A8"
    DA8 = "A8"
    VS8 = "0"
    VT8 = "0"
    UN8 = "A8"
    PH8 = "0"
    TR8 = "1"
    CT8 = "A8"
    NA9 = "A9"
    DA9 = "A9"
    VS9 = "0"
    VT9 = "0"
    UN9 = "A9"
    PH9 = "0"
    TR9 = "1"
    CT9 = "A9"
    NA10 = "A10"
    DA10 = "A10"
    VS10 = "0"
    VT10 = "0"
    UN10 = "A10"
    PH10 = "0"
    TR10 = "1"
    CT10 = "A10"
    NA11 = "A11"
    DA11 = "A11"
    VS11 = "0"
    VT11 = "0"
    UN11 = "A11"
    PH11 = "0"
    TR11 = "1"
    CT11 = "A11"
    NA12 = "A12"
    DA12 = "A12"
    VS12 = "0"
    VT12 = "0"
    UN12 = "A12"
    PH12 = "0"
    TR12 = "1.0"
    CT12 = "A12"
    ND1 = "D1"
    DD1 = "D1"
    NT1 = "0"
    ND2 = "D2"
    DD2 = "D2"
    NT2 = "0"
    ND3 = "D3"
    DD3 = "D3"
    NT3 = "0"
    ND4 = "D4"
    DD4 = "D4"
    NT4 = "0"
    ND5 = "D5"
    DD5 = "D5"
    NT5 = "0"
    ND6 = "D6"
    DD6 = "D6"
    NT6 = "0"
    ND7 = "D7"
    DD7 = "D7"
    NT7 = "0"
    ND8 = "D8"
    DD8 = "D8"
    NT8 = "0"
    ND9 = "D9"
    DD9 = "D9"
    NT9 = "0"
    ND10 = "D10"
    DD10 = "D10"
    NT10 = "0"
    ND11 = "D11"
    DD11 = "D11"
    NT11 = "0"
    ND12 = "D12"
    DD12 = "D12"
    NT12 = "0"
    ND13 = "D13"
    DD13 = "D13"
    NT13 = "0"
    ND14 = "D14"
    DD14 = "D14"
    NT14 = "0"
    ND15 = "D15"
    DD15 = "D15"
    NT15 = "0"
    ND16 = "D16"
    DD16 = "D16"
    NT16 = "0"
    }
   -Wire-([1854,234],0,0,-1)
    {
    Vertex="0,0;0,612"
    }
   0.pgb([1926,1224],0,38497632,470)
    {
    Name = "V2rms"
    Group = ""
    Display = "0"
    Scale = "1.0"
    Units = "kV"
    mrun = "0"
    Pol = "0"
    Min = "220"
    Max = "250"
    }
   0.pgb([1926,1296],0,38500680,530)
    {
    Name = "V4rms"
    Group = ""
    Display = "0"
    Scale = "1.0"
    Units = "kV"
    mrun = "0"
    Pol = "0"
    Min = "220"
    Max = "250"
    }
   -Wire-([720,522],0,0,-1)
    {
    Vertex="0,0;-72,0"
    }
   0.datalabel([864,738],0,0,-1)
    {
    Name = "FT5"
    }
   0.datalabel([522,540],0,0,-1)
    {
    Name = "FT3"
    }
   0.datalabel([522,774],0,0,-1)
    {
    Name = "FT7"
    }
   0.datalabel([234,1080],2,0,-1)
    {
    Name = "B2"
    }
   0.datalabel([270,1080],2,0,-1)
    {
    Name = "B3"
    }
   0.datalabel([198,1080],2,0,-1)
    {
    Name = "B1"
    }
   0.datatap([198,1080],6,0,650)
    {
    Index = "1"
    Dim = "1"
    Type = "1"
    Style = "0"
    Disp = "1"
    }
   0.datalabel([306,1080],2,0,-1)
    {
    Name = "B4"
    }
   0.datatap([306,1080],6,0,620)
    {
    Index = "4"
    Dim = "1"
    Type = "1"
    Style = "0"
    Disp = "1"
    }
   -Wire-([288,1098],0,0,-1)
    {
    Vertex="0,0;-126,0"
    }
   0.datalabel([1206,936],4,0,-1)
    {
    Name = "Breakers"
    }
   0.datalabel([162,1098],0,0,-1)
    {
    Name = "Breakers"
    }
   0.datalabel([432,774],0,0,-1)
    {
    Name = "FT6"
    }
   0.datalabel([666,774],0,0,-1)
    {
    Name = "FT8"
    }
   0.datalabel([1206,972],4,0,-1)
    {
    Name = "Fault"
    }
   0.datalabel([432,558],0,0,-1)
    {
    Name = "Fault"
    }
   0.datalabel([216,756],0,0,-1)
    {
    Name = "Fault"
    }
   0.datalabel([666,558],0,0,-1)
    {
    Name = "Fault"
    }
   0.datalabel([522,792],0,0,-1)
    {
    Name = "Fault"
    }
   0.datalabel([432,792],0,0,-1)
    {
    Name = "Fault"
    }
   0.datalabel([666,792],0,0,-1)
    {
    Name = "Fault"
    }
   0.datalabel([864,756],0,0,-1)
    {
    Name = "Fault"
    }
   0.datalabel([1512,1170],2,0,-1)
    {
    Name = "V4"
    }
   0.datalabel([2088,702],0,0,-1)
    {
    Name = "Fault"
    }
   0.datalabel([2088,882],0,0,-1)
    {
    Name = "Fault"
    }
   0.datalabel([522,558],0,0,-1)
    {
    Name = "Fault"
    }
   0.var([108,702],3,38524616,120)
    {
    Name = "Ph Angle"
    Group = "SS1"
    Display = "0"
    Max = "180"
    Min = "0.0"
    Value = "52.2"
    Units = "deg"
    Collect = "1"
    }
   0.var([54,702],3,38527392,110)
    {
    Name = "Voltage"
    Group = "SS1"
    Display = "0"
    Max = "500"
    Min = "0.0"
    Value = "230.0"
    Units = "kV"
    Collect = "1"
    }
   0.var([954,702],5,38530248,160)
    {
    Name = "Ph Angle"
    Group = "SS2"
    Display = "0"
    Max = "180"
    Min = "-180"
    Value = "20.0"
    Units = "deg"
    Collect = "1"
    }
   0.var([1008,702],5,38533104,170)
    {
    Name = "Voltage"
    Group = "SS2"
    Display = "0"
    Max = "500"
    Min = "0.0"
    Value = "230.0"
    Units = "kV"
    Collect = "1"
    }
   -Sticky-([36,504],0)
    {
    Name = ""
    Font = 1
    Bounds = 36,504,126,540
    Alignment = 0
    Style = 1
    Arrow = 0
    Color = 0,15792890
    Text = "SUBSTATION 1"
    }
   -Wire-([198,1494],0,0,-1)
    {
    Vertex="0,0;72,0"
    }
   0.datalabel([270,1494],0,0,-1)
    {
    Name = "Ron"
    }
   0.tpflt([180,720],0,0,1330)
    {
    Ctype = "1"
    OpCur = "0"
    Grnd = "1"
    View = "1"
    CLVL = "0.0"
    RON = "Ron"
    ROFF = "1.0E6 [ohm]"
    A = "1"
    B = "0"
    C = "0"
    G = "1"
    Ifla = ""
    Iflb = ""
    Iflc = ""
    AG1 = "0"
    }
   0.tpflt([396,756],0,0,1320)
    {
    Ctype = "1"
    OpCur = "0"
    Grnd = "1"
    View = "1"
    CLVL = "0.0"
    RON = "Ron"
    ROFF = "1.0E6 [ohm]"
    A = "1"
    B = "0"
    C = "0"
    G = "1"
    Ifla = ""
    Iflb = ""
    Iflc = ""
    AG1 = "0"
    }
   0.datalabel([666,540],0,0,-1)
    {
    Name = "FT4"
    }
   0.tpflt([702,522],4,0,1340)
    {
    Ctype = "1"
    OpCur = "0"
    Grnd = "1"
    View = "1"
    CLVL = "0.0"
    RON = "Ron"
    ROFF = "1.0E6 [ohm]"
    A = "1"
    B = "0"
    C = "0"
    G = "1"
    Ifla = ""
    Iflb = ""
    Iflc = ""
    AG1 = "0"
    }
   0.tpflt([702,756],4,0,1290)
    {
    Ctype = "1"
    OpCur = "0"
    Grnd = "1"
    View = "1"
    CLVL = "0.0"
    RON = "Ron"
    ROFF = "1.0E6 [ohm]"
    A = "1"
    B = "0"
    C = "0"
    G = "1"
    Ifla = ""
    Iflb = ""
    Iflc = ""
    AG1 = "0"
    }
   0.tpflt([900,720],4,0,1310)
    {
    Ctype = "1"
    OpCur = "0"
    Grnd = "1"
    View = "1"
    CLVL = "0.0"
    RON = "Ron"
    ROFF = "1.0E6 [ohm]"
    A = "1"
    B = "0"
    C = "0"
    G = "1"
    Ifla = ""
    Iflb = ""
    Iflc = ""
    AG1 = "0"
    }
   0.annotation([162,1476],0,0,-1)
    {
    AL1 = "Rf"
    AL2 = ""
    }
   0.datalabel([108,1170],2,0,-1)
    {
    Name = "FT1"
    }
   0.datalabel([144,1170],2,0,-1)
    {
    Name = "FT2"
    }
   0.datalabel([180,1170],2,0,-1)
    {
    Name = "FT3"
    }
   -Wire-([162,1260],0,0,-1)
    {
    Vertex="0,0;0,72"
    }
   0.datalabel([108,1422],0,0,-1)
    {
    Name = "F1"
    }
   0.datalabel([144,1422],0,0,-1)
    {
    Name = "F2"
    }
   0.datalabel([180,1422],0,0,-1)
    {
    Name = "F3"
    }
   0.datalabel([252,1170],2,0,-1)
    {
    Name = "FT5"
    }
   0.datalabel([288,1422],0,0,-1)
    {
    Name = "F6"
    }
   0.var_pot([90,1296],0,38555192,250)
    {
    Name = "Fault location"
    Group = ""
    Display = "0"
    NDP = "8"
    Value = "5"
    F1 = "1.0"
    F2 = "2.0"
    F3 = "3.0"
    F4 = "4.0"
    F5 = "5.0"
    F6 = "6.0"
    F7 = "7.0"
    F8 = "8.0"
    F9 = "9.0"
    F10 = "10.0"
    }
   0.unity([162,1296],0,0,270)
    {
    IType = "2"
    OType = "1"
    }
   0.datatap([108,1170],6,0,1260)
    {
    Index = "1"
    Dim = "1"
    Type = "1"
    Style = "0"
    Disp = "1"
    }
   0.datatap([144,1170],6,0,1250)
    {
    Index = "2"
    Dim = "1"
    Type = "1"
    Style = "0"
    Disp = "1"
    }
   0.datatap([180,1170],6,0,1240)
    {
    Index = "3"
    Dim = "1"
    Type = "1"
    Style = "0"
    Disp = "1"
    }
   0.datatap([288,1170],6,0,1210)
    {
    Index = "6"
    Dim = "1"
    Type = "1"
    Style = "0"
    Disp = "1"
    }
   0.datalabel([216,1170],2,0,-1)
    {
    Name = "FT4"
    }
   0.datatap([108,1422],0,0,1060)
    {
    Index = "1"
    Dim = "1"
    Type = "1"
    Style = "0"
    Disp = "1"
    }
   0.datatap([144,1422],0,0,1050)
    {
    Index = "2"
    Dim = "1"
    Type = "1"
    Style = "0"
    Disp = "1"
    }
   0.datatap([180,1422],0,0,1040)
    {
    Index = "3"
    Dim = "1"
    Type = "1"
    Style = "0"
    Disp = "1"
    }
   0.datatap([216,1422],0,0,1020)
    {
    Index = "4"
    Dim = "1"
    Type = "1"
    Style = "0"
    Disp = "1"
    }
   0.datatap([252,1422],0,0,1000)
    {
    Index = "5"
    Dim = "1"
    Type = "1"
    Style = "0"
    Disp = "1"
    }
   0.datalabel([288,1170],2,0,-1)
    {
    Name = "FT6"
    }
   0.datalabel([252,1422],0,0,-1)
    {
    Name = "F5"
    }
   0.datalabel([216,1422],0,0,-1)
    {
    Name = "F4"
    }
   0.unity([198,1296],4,0,590)
    {
    IType = "2"
    OType = "1"
    }
   0.datalabel([198,1296],1,0,-1)
    {
    Name = "Faulttype"
    }
   -Wire-([198,1260],0,0,-1)
    {
    Vertex="0,0;0,36"
    }
   0.datalabel([198,1332],2,0,-1)
    {
    Name = "Fault"
    }
   0.datatap([270,1080],6,0,630)
    {
    Index = "3"
    Dim = "1"
    Type = "1"
    Style = "0"
    Disp = "1"
    }
   0.datatap([216,1170],6,0,1230)
    {
    Index = "4"
    Dim = "1"
    Type = "1"
    Style = "0"
    Disp = "1"
    }
   0.datatap([324,1170],6,0,1200)
    {
    Index = "7"
    Dim = "1"
    Type = "1"
    Style = "0"
    Disp = "1"
    }
   0.datalabel([324,1170],2,0,-1)
    {
    Name = "FT7"
    }
   0.datalabel([360,1170],2,0,-1)
    {
    Name = "FT8"
    }
   -Wire-([342,1188],0,0,-1)
    {
    Vertex="0,0;-252,0"
    }
   0.datatap([360,1170],6,0,1190)
    {
    Index = "8"
    Dim = "1"
    Type = "1"
    Style = "0"
    Disp = "1"
    }
   -Wire-([342,1404],0,0,-1)
    {
    Vertex="0,0;-252,0"
    }
   0.datatap([288,1422],0,0,990)
    {
    Index = "6"
    Dim = "1"
    Type = "1"
    Style = "0"
    Disp = "1"
    }
   0.datatap([324,1422],0,0,970)
    {
    Index = "7"
    Dim = "1"
    Type = "1"
    Style = "0"
    Disp = "1"
    }
   0.datatap([360,1422],0,0,950)
    {
    Index = "8"
    Dim = "1"
    Type = "1"
    Style = "0"
    Disp = "1"
    }
   0.datalabel([360,1422],0,0,-1)
    {
    Name = "F8"
    }
   0.datatap([234,1080],6,0,640)
    {
    Index = "2"
    Dim = "1"
    Type = "1"
    Style = "0"
    Disp = "1"
    }
   0.datalabel([324,1422],0,0,-1)
    {
    Name = "F7"
    }
   0.mux_array([180,1368],6,0,610)
    {
    DPath = "0"
    }
   0.var_pot([270,1296],2,38587424,290)
    {
    Name = "Fault Type"
    Group = ""
    Display = "0"
    NDP = "10"
    Value = "7"
    F1 = "1.0"
    F2 = "2.0"
    F3 = "3.0"
    F4 = "4.0"
    F5 = "5.0"
    F6 = "6.0"
    F7 = "7.0"
    F8 = "8.0"
    F9 = "9.0"
    F10 = "0"
    }
   0.pgb([1206,1404],0,38590320,820)
    {
    Name = "PS1"
    Group = ""
    Display = "0"
    Scale = "1"
    Units = "MW"
    mrun = "0"
    Pol = "0"
    Min = "-300"
    Max = "300"
    }
   0.pgb([1206,1440],0,38593512,740)
    {
    Name = "QS1"
    Group = ""
    Display = "0"
    Scale = "1"
    Units = "MVAR"
    mrun = "0"
    Pol = "0"
    Min = "-100"
    Max = "100"
    }
   0.pgb([1314,1404],0,38596424,790)
    {
    Name = "PS2"
    Group = ""
    Display = "0"
    Scale = "1"
    Units = "MW"
    mrun = "0"
    Pol = "0"
    Min = "-300"
    Max = "300"
    }
   -Wire-([828,630],0,0,-1)
    {
    Vertex="0,0;108,0"
    }
   -Bus-([828,486],0,126819640,-1)
    {
    P1 = [0,0]
    P2 = [0,306]
    I = 1
    BASKV = 0
    IDE = 0
    GL = 0
    BL = 0
    AREA = 1
    ZONE = 0
    VM = 0
    VA = 0
    OWNER = 1
    }
   0.breaker3([792,522],0,0,680)
    {
    Ctrl = "0"
    OPCUR = "0"
    ENAB = "0"
    CLVL = "0.0"
    View = "1"
    ViewB = "1"
    DisPQ = "1"
    NAME = "B2"
    NAMEA = "BRKA"
    NAMEB = "BRKB"
    NAMEC = "BRKC"
    ROFF = "1.0e6 [ohm]"
    RON = "0.1 [ohm]"
    PRER = "0.5 [ohm]"
    TDA = "0.0 [s]"
    TDB = "0.0 [s]"
    TDC = "0.0 [s]"
    TDRA = "0.05 [s]"
    TDRB = "0.05 [s]"
    TDRC = "0.05 [s]"
    PostIns = "0"
    TDBOA = "0.005"
    IBRA = "I2A"
    IBRB = "I2B"
    IBRC = "I2C"
    IBR0 = "I20"
    SBRA = "Br2A"
    SBRB = "Br2B"
    SBRC = "Br2C"
    BP = "P2"
    BQ = "Q2"
    BOpen1 = "0"
    BOpen2 = "0"
    BOpen3 = "0"
    P = "-372.9 [MW]"
    Q = "110.3 [MVAR]"
    }
   -Bus-([270,486],0,126823088,-1)
    {
    P1 = [0,0]
    P2 = [0,306]
    I = 1
    BASKV = 0
    IDE = 0
    GL = 0
    BL = 0
    AREA = 1
    ZONE = 0
    VM = 0
    VA = 0
    OWNER = 1
    }
   0.tpflt([396,522],0,0,1370)
    {
    Ctype = "1"
    OpCur = "0"
    Grnd = "1"
    View = "1"
    CLVL = "0.0"
    RON = "Ron"
    ROFF = "1.0E6 [ohm]"
    A = "1"
    B = "0"
    C = "0"
    G = "1"
    Ifla = ""
    Iflb = ""
    Iflc = ""
    AG1 = "0"
    }
   0.tpflt([558,522],4,0,1350)
    {
    Ctype = "1"
    OpCur = "0"
    Grnd = "1"
    View = "1"
    CLVL = "0.0"
    RON = "Ron"
    ROFF = "1.0E6 [ohm]"
    A = "1"
    B = "0"
    C = "0"
    G = "1"
    Ifla = ""
    Iflb = ""
    Iflc = ""
    AG1 = "0"
    }
   0.source3R([90,630],6,0,570)
    {
    Name = "Source1"
    MVA = "100.0 [MVA]"
    Vm = "230.0 [kV]"
    F = "$(f)"
    Tc = "0.05 [s]"
    Ideal = "0"
    ZSeq = "1"
    Imp = "1"
    View = "1"
    details = "1"
    Z1 = "5.29 [ohm]"
    Phi1 = "80.0 [deg]"
    R1p = "1.0 [ohm]"
    X1p = "0.1 [ohm]"
    Z0 = "52.9 [ohm]"
    Phi0 = "80.0 [deg]"
    R0p = "1.0 [ohm]"
    X0p = "0.1 [ohm]"
    P = "S1W"
    Q = "S1Q"
    Ia = ""
    Ib = ""
    Ic = ""
    }
   0.source3R([972,630],2,0,580)
    {
    Name = "Source2"
    MVA = "100.0 [MVA]"
    Vm = "230.0 [kV]"
    F = "$(f)"
    Tc = "0.05 [s]"
    Ideal = "0"
    ZSeq = "1"
    Imp = "1"
    View = "1"
    details = "1"
    Z1 = "5.29 [ohm]"
    Phi1 = "80.0 [deg]"
    R1p = "1.0 [ohm]"
    X1p = "0.1 [ohm]"
    Z0 = "52.9 [ohm]"
    Phi0 = "80.0 [deg]"
    R0p = "1.0 [ohm]"
    X0p = "0.1 [ohm]"
    P = "S2W"
    Q = "S2Q"
    Ia = ""
    Ib = ""
    Ic = ""
    }
   0.tpflt([558,756],4,0,1300)
    {
    Ctype = "1"
    OpCur = "0"
    Grnd = "1"
    View = "1"
    CLVL = "0.0"
    RON = "Ron"
    ROFF = "1.0E6 [ohm]"
    A = "1"
    B = "0"
    C = "0"
    G = "1"
    Ifla = ""
    Iflb = ""
    Iflc = ""
    AG1 = "0"
    }
   .Plots_B2([792,414],0,0,60)
    {
    }
   .Plots_B1([306,414],0,0,40)
    {
    }
   0.const([1674,162],1,0,20)
    {
    Name = ""
    Value = "10.0"
    }
   0.pgb([1800,1368],0,38616688,770)
    {
    Name = "Q4"
    Group = ""
    Display = "0"
    Scale = "1.0"
    Units = "MVAR"
    mrun = "0"
    Pol = "0"
    Min = "-50"
    Max = "50"
    }
   0.pgb([1584,1206],0,38619784,370)
    {
    Name = "V4a"
    Group = ""
    Display = "0"
    Scale = "1.0"
    Units = "kV"
    mrun = "0"
    Pol = "0"
    Min = "-200.0"
    Max = "200.0"
    }
   0.pgb([1206,1206],0,38622696,1170)
    {
    Name = "Br1a"
    Group = ""
    Display = "0"
    Scale = "1.0"
    Units = ""
    mrun = "0"
    Pol = "0"
    Min = "-0.1"
    Max = "0.1"
    }
   -Sticky-([900,1080],0)
    {
    Name = ""
    Font = 1
    Bounds = 900,1080,1008,1116
    Alignment = 0
    Style = 1
    Arrow = 0
    Color = 0,15792890
    Text = "OUTPUT CHANNELS"
    }
   0.pgb([1314,1440],0,38625736,720)
    {
    Name = "QS2"
    Group = ""
    Display = "0"
    Scale = "1"
    Units = "MVAR"
    mrun = "0"
    Pol = "0"
    Min = "-100"
    Max = "100"
    }
   0.mux_array([180,1224],0,0,1180)
    {
    DPath = "0"
    }
   0.datatap([252,1170],6,0,1220)
    {
    Index = "5"
    Dim = "1"
    Type = "1"
    Style = "0"
    Disp = "1"
    }
   0.var([162,1494],0,38630632,540)
    {
    Name = "Rf"
    Group = ""
    Display = "0"
    Max = "50"
    Min = "0.001"
    Value = "0.001"
    Units = "ohm"
    Collect = "1"
    }
   0.recorder2_0([1980,810],0,0,1270)
    {
    FName = "stn4"
    FFMT = "2"
    Rstep = "50"
    Mfilter = "0"
    FREQ = "1"
    StnN = "EMTDC_Simulation"
    DevNo = "4"
    NChA = "6"
    NChD = "1"
    ABFMT = "0"
    MFILE = "0"
    NxHdr = "0"
    AMin = "0"
    AMax = "4096"
    ENTCAP = "0"
    Hdr1 = "Extra_Line_1"
    Hdr2 = "Extra_Line_2"
    Hdr3 = "Extra_Line_3"
    Hdr4 = "Extra_Line_4"
    Hdr5 = "Extra_Line_5"
    NA1 = "V2a"
    DA1 = "A1"
    VS1 = "0"
    VT1 = "0"
    UN1 = "A1"
    PH1 = "0"
    TR1 = "1"
    CT1 = "A1"
    NA2 = "V2b"
    DA2 = "A2"
    VS2 = "0"
    VT2 = "0"
    UN2 = "A2"
    PH2 = "0"
    TR2 = "1"
    CT2 = "A2"
    NA3 = "V2c"
    DA3 = "A3"
    VS3 = "0"
    VT3 = "0"
    UN3 = "A3"
    PH3 = "0"
    TR3 = "1"
    CT3 = "A3"
    NA4 = "I2a"
    DA4 = "A4"
    VS4 = "0"
    VT4 = "1"
    UN4 = "A4"
    PH4 = "0"
    TR4 = "1"
    CT4 = "A4"
    NA5 = "I2b"
    DA5 = "A5"
    VS5 = "0"
    VT5 = "1"
    UN5 = "A5"
    PH5 = "0"
    TR5 = "1"
    CT5 = "A5"
    NA6 = "I2c"
    DA6 = "A6"
    VS6 = "0"
    VT6 = "1"
    UN6 = "A6"
    PH6 = "0"
    TR6 = "1"
    CT6 = "A6"
    NA7 = "A7"
    DA7 = "A7"
    VS7 = "0"
    VT7 = "0"
    UN7 = "A7"
    PH7 = "0"
    TR7 = "1"
    CT7 = "A7"
    NA8 = "A8"
    DA8 = "A8"
    VS8 = "0"
    VT8 = "0"
    UN8 = "A8"
    PH8 = "0"
    TR8 = "1"
    CT8 = "A8"
    NA9 = "A9"
    DA9 = "A9"
    VS9 = "0"
    VT9 = "0"
    UN9 = "A9"
    PH9 = "0"
    TR9 = "1"
    CT9 = "A9"
    NA10 = "A10"
    DA10 = "A10"
    VS10 = "0"
    VT10 = "0"
    UN10 = "A10"
    PH10 = "0"
    TR10 = "1"
    CT10 = "A10"
    NA11 = "A11"
    DA11 = "A11"
    VS11 = "0"
    VT11 = "0"
    UN11 = "A11"
    PH11 = "0"
    TR11 = "1"
    CT11 = "A11"
    NA12 = "A12"
    DA12 = "A12"
    VS12 = "0"
    VT12 = "0"
    UN12 = "A12"
    PH12 = "0"
    TR12 = "1.0"
    CT12 = "A12"
    ND1 = "D1"
    DD1 = "D1"
    NT1 = "0"
    ND2 = "D2"
    DD2 = "D2"
    NT2 = "0"
    ND3 = "D3"
    DD3 = "D3"
    NT3 = "0"
    ND4 = "D4"
    DD4 = "D4"
    NT4 = "0"
    ND5 = "D5"
    DD5 = "D5"
    NT5 = "0"
    ND6 = "D6"
    DD6 = "D6"
    NT6 = "0"
    ND7 = "D7"
    DD7 = "D7"
    NT7 = "0"
    ND8 = "D8"
    DD8 = "D8"
    NT8 = "0"
    ND9 = "D9"
    DD9 = "D9"
    NT9 = "0"
    ND10 = "D10"
    DD10 = "D10"
    NT10 = "0"
    ND11 = "D11"
    DD11 = "D11"
    NT11 = "0"
    ND12 = "D12"
    DD12 = "D12"
    NT12 = "0"
    ND13 = "D13"
    DD13 = "D13"
    NT13 = "0"
    ND14 = "D14"
    DD14 = "D14"
    NT14 = "0"
    ND15 = "D15"
    DD15 = "D15"
    NT15 = "0"
    ND16 = "D16"
    DD16 = "D16"
    NT16 = "0"
    }
   0.recorder2_0([1980,198],0,0,1380)
    {
    FName = "stn1"
    FFMT = "2"
    Rstep = "50"
    Mfilter = "0"
    FREQ = "1"
    StnN = "EMTDC_Simulation"
    DevNo = "1"
    NChA = "6"
    NChD = "1"
    ABFMT = "0"
    MFILE = "0"
    NxHdr = "0"
    AMin = "0"
    AMax = "4096"
    ENTCAP = "0"
    Hdr1 = "Extra_Line_1"
    Hdr2 = "Extra_Line_2"
    Hdr3 = "Extra_Line_3"
    Hdr4 = "Extra_Line_4"
    Hdr5 = "Extra_Line_5"
    NA1 = "V1a"
    DA1 = "A1"
    VS1 = "0"
    VT1 = "0"
    UN1 = "A1"
    PH1 = "0"
    TR1 = "1"
    CT1 = "A1"
    NA2 = "V1b"
    DA2 = "A2"
    VS2 = "0"
    VT2 = "0"
    UN2 = "A2"
    PH2 = "0"
    TR2 = "1"
    CT2 = "A2"
    NA3 = "V1c"
    DA3 = "A3"
    VS3 = "0"
    VT3 = "0"
    UN3 = "A3"
    PH3 = "0"
    TR3 = "1"
    CT3 = "A3"
    NA4 = "I1a"
    DA4 = "A4"
    VS4 = "0"
    VT4 = "1"
    UN4 = "A4"
    PH4 = "0"
    TR4 = "1"
    CT4 = "A4"
    NA5 = "I1b"
    DA5 = "A5"
    VS5 = "0"
    VT5 = "1"
    UN5 = "A5"
    PH5 = "0"
    TR5 = "1"
    CT5 = "A5"
    NA6 = "I1c"
    DA6 = "A6"
    VS6 = "0"
    VT6 = "1"
    UN6 = "A6"
    PH6 = "0"
    TR6 = "1"
    CT6 = "A6"
    NA7 = "A7"
    DA7 = "A7"
    VS7 = "0"
    VT7 = "0"
    UN7 = "A7"
    PH7 = "0"
    TR7 = "1"
    CT7 = "A7"
    NA8 = "A8"
    DA8 = "A8"
    VS8 = "0"
    VT8 = "0"
    UN8 = "A8"
    PH8 = "0"
    TR8 = "1"
    CT8 = "A8"
    NA9 = "A9"
    DA9 = "A9"
    VS9 = "0"
    VT9 = "0"
    UN9 = "A9"
    PH9 = "0"
    TR9 = "1"
    CT9 = "A9"
    NA10 = "A10"
    DA10 = "A10"
    VS10 = "0"
    VT10 = "0"
    UN10 = "A10"
    PH10 = "0"
    TR10 = "1"
    CT10 = "A10"
    NA11 = "A11"
    DA11 = "A11"
    VS11 = "0"
    VT11 = "0"
    UN11 = "A11"
    PH11 = "0"
    TR11 = "1"
    CT11 = "A11"
    NA12 = "A12"
    DA12 = "A12"
    VS12 = "0"
    VT12 = "0"
    UN12 = "A12"
    PH12 = "0"
    TR12 = "1.0"
    CT12 = "A12"
    ND1 = "D1"
    DD1 = "D1"
    NT1 = "0"
    ND2 = "D2"
    DD2 = "D2"
    NT2 = "0"
    ND3 = "D3"
    DD3 = "D3"
    NT3 = "0"
    ND4 = "D4"
    DD4 = "D4"
    NT4 = "0"
    ND5 = "D5"
    DD5 = "D5"
    NT5 = "0"
    ND6 = "D6"
    DD6 = "D6"
    NT6 = "0"
    ND7 = "D7"
    DD7 = "D7"
    NT7 = "0"
    ND8 = "D8"
    DD8 = "D8"
    NT8 = "0"
    ND9 = "D9"
    DD9 = "D9"
    NT9 = "0"
    ND10 = "D10"
    DD10 = "D10"
    NT10 = "0"
    ND11 = "D11"
    DD11 = "D11"
    NT11 = "0"
    ND12 = "D12"
    DD12 = "D12"
    NT12 = "0"
    ND13 = "D13"
    DD13 = "D13"
    NT13 = "0"
    ND14 = "D14"
    DD14 = "D14"
    NT14 = "0"
    ND15 = "D15"
    DD15 = "D15"
    NT15 = "0"
    ND16 = "D16"
    DD16 = "D16"
    NT16 = "0"
    }
   0.select([1710,198],6,0,550)
    {
    A = "1"
    DPath = "1"
    COM = "Selector"
    }
   0.const([1674,342],1,0,70)
    {
    Name = ""
    Value = "10.0"
    }
   0.select([1710,378],6,0,560)
    {
    A = "1"
    DPath = "1"
    COM = "Selector"
    }
   0.const([1710,594],1,0,140)
    {
    Name = ""
    Value = "10.0"
    }
   0.select([1746,630],6,0,180)
    {
    A = "1"
    DPath = "1"
    COM = "Selector"
    }
   0.const([1710,774],1,0,210)
    {
    Name = ""
    Value = "10.0"
    }
   0.select([1746,810],6,0,220)
    {
    A = "1"
    DPath = "1"
    COM = "Selector"
    }
   0.var([1602,522],0,38662040,100)
    {
    Name = "Start"
    Group = ""
    Display = "0"
    Max = "1.0"
    Min = "0.0"
    Value = "0.15"
    Units = "s"
    Collect = "1"
    }
   -Wire-([1638,234],0,0,-1)
    {
    Vertex="0,0;0,612"
    }
   -Wire-([1638,414],0,0,-1)
    {
    Vertex="0,0;36,0"
    }
   -Wire-([1638,234],0,0,-1)
    {
    Vertex="0,0;36,0"
    }
   -Wire-([1746,378],0,0,-1)
    {
    Vertex="0,0;126,0"
    }
   -Wire-([1746,198],0,0,-1)
    {
    Vertex="0,0;126,0"
    }
   -Wire-([1782,630],0,0,-1)
    {
    Vertex="0,0;90,0"
    }
   -Wire-([1782,810],0,0,-1)
    {
    Vertex="0,0;90,0"
    }
   -Wire-([1638,846],0,0,-1)
    {
    Vertex="0,0;72,0"
    }
   -Wire-([1638,666],0,0,-1)
    {
    Vertex="0,0;72,0"
    }
   0.var_switch([1710,126],1,38668872,10)
    {
    Name = "en Record1"
    Group = ""
    Display = "0"
    Value = "1"
    Max = "1"
    Min = "0"
    Ton = "ON"
    Toff = "OFF"
    }
   0.var_switch([1710,306],1,38671592,50)
    {
    Name = "en Record2"
    Group = ""
    Display = "0"
    Value = "1"
    Max = "1"
    Min = "0"
    Ton = "ON"
    Toff = "OFF"
    }
   0.var_switch([1746,558],1,38674312,130)
    {
    Name = "en Record3"
    Group = ""
    Display = "0"
    Value = "1"
    Max = "1"
    Min = "0"
    Ton = "ON"
    Toff = "OFF"
    }
   0.var_switch([1746,738],1,38677032,200)
    {
    Name = "en Record4"
    Group = ""
    Display = "0"
    Value = "1"
    Max = "1"
    Min = "0"
    Ton = "ON"
    Toff = "OFF"
    }
   0.datalabel([1206,990],4,0,-1)
    {
    Name = "FaultType"
    }
   -Wire-([1260,990],0,0,-1)
    {
    Vertex="0,0;-54,0"
    }
   -Wire-([1260,972],0,0,-1)
    {
    Vertex="0,0;-54,0"
    }
   -Wire-([1260,936],0,0,-1)
    {
    Vertex="0,0;-54,0"
    }
   -TLine-([432,522],0,109805160,-1)
    {
    Name = "T1"
    Date = 1144683531
    Freq = "$(f)"
    Length = "50 [km]"
    Dim = 3
    Mode = 1
    Vertex="0,0;18,0;90,0;108,0"
    PageLayer(A/A4,Landscape,18,[597,467],100)
     {
     0.Line_Ground([630,702],0,88919208,-1)
      {
      GRRES = "100.0 [ohm*m]"
      GPERM = "1.0"
      EarthForm = "0"
      }
     0.Line_FrePhase_Options([216,468],0,121202888,-1)
      {
      Interp1 = "1"
      Output = "0"
      Inflen = "0"
      FS = "0.5 [Hz]"
      FE = "1.0E6 [Hz]"
      Numf = "100"
      YMaxP = "20"
      AMaxP = "20"
      YMaxE = "2 [%]"
      AMaxE = "2 [%]"
      xxx = ""
      W1 = "100"
      W2 = "1000"
      W3 = "1"
      }
     0.SequenceInfo([522,144],0,23624768,-1)
      {
      Mode = "0"
      X1 = "1.787240475"
      Y1 = "25.3881338"
      X2 = "1.787240475"
      Y2 = "25.3881338"
      X3 = "18.15761005"
      Y3 = "66.3236615"
      X4 = "5.0e-006"
      Y4 = "0.000163558973"
      X5 = "0.0"
      Y5 = "0.0"
      X6 = "5.0e-006"
      Y6 = "0.000116133049"
      M1 = "25.4509639574"
      P1 = "85.9732100966"
      M2 = "25.4509639574"
      P2 = "85.9732100966"
      M3 = "68.7642848977"
      P3 = "74.6891426178"
      M4 = "0.000163635380187"
      P4 = "88.249012563"
      M5 = "0.0"
      P5 = "0.0"
      M6 = "0.000116240634333"
      P6 = "87.5347062197"
      }
     0.Line_Tower_3_Delta([810,612],0,23625208,-1)
      {
      TName = "3H5"
      Y = "30 [m]"
      Y2 = "5 [m]"
      XC = "10 [m]"
      X = "0 [m]"
      ShuntG = "1.0E-10 [mho/m]"
      SHSag = "0"
      Transp = "1"
      NG = "2"
      ElimGW = "1"
      CDataType = "1"
      CName = "chukar"
      CLName = "..\\conductor.clb"
      RadiusC = "0.0203454 [m]"
      DCResC = "0.03206 [ohm/km]"
      SAGC = "10 [m]"
      NCondB = "1"
      BundSym = "0"
      SHBund = "1"
      BSP = ".4572 [m]"
      GDataType = "1"
      GName = "1/2\"HighStrengthSteel"
      GLName = "..\\conductor.clb"
      RadiusG = "0.0055245 [m]"
      DCResG = "2.8645 [ohm/km]"
      SAGG = "10 [m]"
      YG = "10 [m]"
      XG = "10 [m]"
      XB1 = "-0.1 [m]"
      YB1 = "0.1 [m]"
      XB2 = "-0.1 [m]"
      YB2 = "0.1 [m]"
      XB3 = "-0.1 [m]"
      YB3 = "0.1 [m]"
      XB4 = "-0.1 [m]"
      YB4 = "0.1 [m]"
      XB5 = "-0.1 [m]"
      YB5 = "0.1 [m]"
      XB6 = "-0.1 [m]"
      YB6 = "0.1 [m]"
      XB7 = "-0.1 [m]"
      YB7 = "0.1 [m]"
      XB8 = "-0.1 [m]"
      YB8 = "0.1 [m]"
      XB9 = "-0.1 [m]"
      YB9 = "0.1 [m]"
      XB10 = "-0.1 [m]"
      YB10 = "0.1 [m]"
      NC1 = "1"
      NC2 = "2"
      NC3 = "3"
      NG1 = "4"
      NG2 = "5"
      }
     }
    }
   -TLine-([432,738],0,71050056,-1)
    {
    Name = "T3"
    Date = 1144683532
    Freq = "$(f)"
    Length = "75 [km]"
    Dim = 3
    Mode = 1
    Vertex="0,0;18,0;90,0;108,0"
    PageLayer(A/A4,Landscape,16,[597,467],100)
     {
     0.Line_Ground([630,702],0,44343304,-1)
      {
      GRRES = "100.0 [ohm*m]"
      GPERM = "1.0"
      EarthForm = "0"
      }
     0.Line_FrePhase_Options([216,468],0,110465032,-1)
      {
      Interp1 = "1"
      Output = "0"
      Inflen = "0"
      FS = "0.5 [Hz]"
      FE = "1.0E6 [Hz]"
      Numf = "100"
      YMaxP = "20"
      AMaxP = "20"
      YMaxE = "2 [%]"
      AMaxE = "2 [%]"
      xxx = ""
      W1 = "100"
      W2 = "1000"
      W3 = "1"
      }
     0.Line_Tower_3_Delta([810,612],0,110465392,-1)
      {
      TName = "3H5"
      Y = "30 [m]"
      Y2 = "5 [m]"
      XC = "10 [m]"
      X = "0 [m]"
      ShuntG = "1.0E-10 [mho/m]"
      SHSag = "0"
      Transp = "1"
      NG = "2"
      ElimGW = "1"
      CDataType = "1"
      CName = "chukar"
      CLName = "C:\\home\\user\\pscad\\lineconstants\\database\\acsr.clb"
      RadiusC = "0.0203454 [m]"
      DCResC = "0.03206 [ohm/km]"
      SAGC = "10 [m]"
      NCondB = "1"
      BundSym = "0"
      SHBund = "1"
      BSP = ".4572 [m]"
      GDataType = "1"
      GName = "1/2\"HighStrengthSteel"
      GLName = "C:\\home\\user\\pscad\\lineconstants\\database\\gw.clb"
      RadiusG = "0.0055245 [m]"
      DCResG = "2.8645 [ohm/km]"
      SAGG = "10 [m]"
      YG = "10 [m]"
      XG = "10 [m]"
      XB1 = "-0.1 [m]"
      YB1 = "0.1 [m]"
      XB2 = "-0.1 [m]"
      YB2 = "0.1 [m]"
      XB3 = "-0.1 [m]"
      YB3 = "0.1 [m]"
      XB4 = "-0.1 [m]"
      YB4 = "0.1 [m]"
      XB5 = "-0.1 [m]"
      YB5 = "0.1 [m]"
      XB6 = "-0.1 [m]"
      YB6 = "0.1 [m]"
      XB7 = "-0.1 [m]"
      YB7 = "0.1 [m]"
      XB8 = "-0.1 [m]"
      YB8 = "0.1 [m]"
      XB9 = "-0.1 [m]"
      YB9 = "0.1 [m]"
      XB10 = "-0.1 [m]"
      YB10 = "0.1 [m]"
      NC1 = "1"
      NC2 = "2"
      NC3 = "3"
      NG1 = "4"
      NG2 = "5"
      }
     0.SequenceInfo([522,198],0,112869944,-1)
      {
      Mode = "1"
      X1 = "2.6808607125"
      Y1 = "38.0822007"
      X2 = "2.6808607125"
      Y2 = "38.0822007"
      X3 = "27.236415075"
      Y3 = "99.48549225"
      X4 = "7.5e-006"
      Y4 = "0.0002453384595"
      X5 = "0.0"
      Y5 = "0.0"
      X6 = "7.5e-006"
      Y6 = "0.0001741995735"
      M1 = "38.1764459361"
      P1 = "85.9732100966"
      M2 = "38.1764459361"
      P2 = "85.9732100966"
      M3 = "103.146427347"
      P3 = "74.6891426178"
      M4 = "0.00024545307028"
      P4 = "88.249012563"
      M5 = "0.0"
      P5 = "0.0"
      M6 = "0.000174360951499"
      P6 = "87.5347062197"
      }
     }
    }
   -TLine-([540,738],0,112947208,-1)
    {
    Name = "T4"
    Date = 1144683532
    Freq = "$(f)"
    Length = "25 [km]"
    Dim = 3
    Mode = 1
    Vertex="0,0;18,0;90,0;108,0"
    PageLayer(A/A4,Landscape,16,[597,467],100)
     {
     0.Line_Ground([630,702],0,42915360,-1)
      {
      GRRES = "100.0 [ohm*m]"
      GPERM = "1.0"
      EarthForm = "0"
      }
     0.Line_FrePhase_Options([216,468],0,74870312,-1)
      {
      Interp1 = "1"
      Output = "0"
      Inflen = "0"
      FS = "0.5 [Hz]"
      FE = "1.0E6 [Hz]"
      Numf = "100"
      YMaxP = "20"
      AMaxP = "20"
      YMaxE = "2 [%]"
      AMaxE = "2 [%]"
      xxx = ""
      W1 = "100"
      W2 = "1000"
      W3 = "1"
      }
     0.Line_Tower_3_Delta([810,612],0,36601880,-1)
      {
      TName = "3H5"
      Y = "30 [m]"
      Y2 = "5 [m]"
      XC = "10 [m]"
      X = "0 [m]"
      ShuntG = "1.0E-10 [mho/m]"
      SHSag = "0"
      Transp = "1"
      NG = "2"
      ElimGW = "1"
      CDataType = "1"
      CName = "chukar"
      CLName = "..\\conductor.clb"
      RadiusC = "0.0203454 [m]"
      DCResC = "0.03206 [ohm/km]"
      SAGC = "10 [m]"
      NCondB = "1"
      BundSym = "0"
      SHBund = "1"
      BSP = ".4572 [m]"
      GDataType = "1"
      GName = "1/2\"HighStrengthSteel"
      GLName = "..\\conductor.clb"
      RadiusG = "0.0055245 [m]"
      DCResG = "2.8645 [ohm/km]"
      SAGG = "10 [m]"
      YG = "10 [m]"
      XG = "10 [m]"
      XB1 = "-0.1 [m]"
      YB1 = "0.1 [m]"
      XB2 = "-0.1 [m]"
      YB2 = "0.1 [m]"
      XB3 = "-0.1 [m]"
      YB3 = "0.1 [m]"
      XB4 = "-0.1 [m]"
      YB4 = "0.1 [m]"
      XB5 = "-0.1 [m]"
      YB5 = "0.1 [m]"
      XB6 = "-0.1 [m]"
      YB6 = "0.1 [m]"
      XB7 = "-0.1 [m]"
      YB7 = "0.1 [m]"
      XB8 = "-0.1 [m]"
      YB8 = "0.1 [m]"
      XB9 = "-0.1 [m]"
      YB9 = "0.1 [m]"
      XB10 = "-0.1 [m]"
      YB10 = "0.1 [m]"
      NC1 = "1"
      NC2 = "2"
      NC3 = "3"
      NG1 = "4"
      NG2 = "5"
      }
     0.SequenceInfo([522,198],0,21680520,-1)
      {
      Mode = "1"
      X1 = "0.8936202375"
      Y1 = "12.6940669"
      X2 = "0.8936202375"
      Y2 = "12.6940669"
      X3 = "9.078805025"
      Y3 = "33.16183075"
      X4 = "2.5e-006"
      Y4 = "8.17794865e-005"
      X5 = "0.0"
      Y5 = "0.0"
      X6 = "2.5e-006"
      Y6 = "5.80665245e-005"
      M1 = "12.7254819787"
      P1 = "85.9732100966"
      M2 = "12.7254819787"
      P2 = "85.9732100966"
      M3 = "34.3821424489"
      P3 = "74.6891426178"
      M4 = "8.18176900933e-005"
      P4 = "88.249012563"
      M5 = "0.0"
      P5 = "0.0"
      M6 = "5.81203171663e-005"
      P6 = "87.5347062197"
      }
     }
    }
   -TLine-([540,522],0,109728568,-1)
    {
    Name = "T2"
    Date = 1144683533
    Freq = "$(f)"
    Length = "50 [km]"
    Dim = 3
    Mode = 1
    Vertex="0,0;18,0;90,0;108,0"
    PageLayer(A/A4,Landscape,16,[597,467],100)
     {
     0.Line_Ground([630,702],0,125798616,-1)
      {
      GRRES = "100.0 [ohm*m]"
      GPERM = "1.0"
      EarthForm = "0"
      }
     0.Line_FrePhase_Options([216,468],0,30993688,-1)
      {
      Interp1 = "1"
      Output = "0"
      Inflen = "0"
      FS = "0.5 [Hz]"
      FE = "1.0E6 [Hz]"
      Numf = "100"
      YMaxP = "20"
      AMaxP = "20"
      YMaxE = "2 [%]"
      AMaxE = "2 [%]"
      xxx = ""
      W1 = "100"
      W2 = "1000"
      W3 = "1"
      }
     0.SequenceInfo([522,198],0,73478152,-1)
      {
      Mode = "0"
      X1 = "1.787240475"
      Y1 = "25.3881338"
      X2 = "1.787240475"
      Y2 = "25.3881338"
      X3 = "18.15761005"
      Y3 = "66.3236615"
      X4 = "5.0e-006"
      Y4 = "0.000163558973"
      X5 = "0.0"
      Y5 = "0.0"
      X6 = "5.0e-006"
      Y6 = "0.000116133049"
      M1 = "25.4509639574"
      P1 = "85.9732100966"
      M2 = "25.4509639574"
      P2 = "85.9732100966"
      M3 = "68.7642848977"
      P3 = "74.6891426178"
      M4 = "0.000163635380187"
      P4 = "88.249012563"
      M5 = "0.0"
      P5 = "0.0"
      M6 = "0.000116240634333"
      P6 = "87.5347062197"
      }
     0.Line_Tower_3_Delta([810,612],0,73478608,-1)
      {
      TName = "3H5"
      Y = "30 [m]"
      Y2 = "5 [m]"
      XC = "10 [m]"
      X = "0 [m]"
      ShuntG = "1.0E-10 [mho/m]"
      SHSag = "0"
      Transp = "1"
      NG = "2"
      ElimGW = "1"
      CDataType = "1"
      CName = "chukar"
      CLName = "C:\\home\\user\\pscad\\lineconstants\\database\\acsr.clb"
      RadiusC = "0.0203454 [m]"
      DCResC = "0.03206 [ohm/km]"
      SAGC = "10 [m]"
      NCondB = "1"
      BundSym = "0"
      SHBund = "1"
      BSP = ".4572 [m]"
      GDataType = "1"
      GName = "1/2\"HighStrengthSteel"
      GLName = "C:\\home\\user\\pscad\\lineconstants\\database\\gw.clb"
      RadiusG = "0.0055245 [m]"
      DCResG = "2.8645 [ohm/km]"
      SAGG = "10 [m]"
      YG = "10 [m]"
      XG = "10 [m]"
      XB1 = "-0.1 [m]"
      YB1 = "0.1 [m]"
      XB2 = "-0.1 [m]"
      YB2 = "0.1 [m]"
      XB3 = "-0.1 [m]"
      YB3 = "0.1 [m]"
      XB4 = "-0.1 [m]"
      YB4 = "0.1 [m]"
      XB5 = "-0.1 [m]"
      YB5 = "0.1 [m]"
      XB6 = "-0.1 [m]"
      YB6 = "0.1 [m]"
      XB7 = "-0.1 [m]"
      YB7 = "0.1 [m]"
      XB8 = "-0.1 [m]"
      YB8 = "0.1 [m]"
      XB9 = "-0.1 [m]"
      YB9 = "0.1 [m]"
      XB10 = "-0.1 [m]"
      YB10 = "0.1 [m]"
      NC1 = "1"
      NC2 = "2"
      NC3 = "3"
      NG1 = "4"
      NG2 = "5"
      }
     }
    }
   -Wire-([378,738],0,0,-1)
    {
    Vertex="0,0;54,0"
    }
   -Wire-([720,738],0,0,-1)
    {
    Vertex="0,0;-72,0"
    }
   -Sticky-([882,504],0)
    {
    Name = ""
    Font = 1
    Bounds = 882,504,972,540
    Alignment = 0
    Style = 1
    Arrow = 0
    Color = 0,15792890
    Text = "SUBSTATION 2"
    }
   .Controls([1296,972],4,0,600)
    {
    }
   -Sticky-([18,18],0)
    {
    Name = ""
    Font = 1
    Bounds = 18,18,612,234
    Alignment = 0
    Style = 0
    Arrow = 0
    Color = 0,15792890
    Text = "\
Case 4: 
- Two Thevinen Impedance sources connected via two 100km transmission lines.
- Faults can be applied Midline on Line 1 or Line 2
- User  must  ensure the sum of lines T1+ T2, and T3 + T4, equal the total
   length of the lines they wish to simulate.
- System voltage is 230kV settable via source equivalents.
- Simulates two substations connected via two transmission lines.
- Eight fault positions for full fault control ahead and behind station relays.
- Four breakers are independently timed controlled. (Default is closed).
- Independent breaker pole tripping is possible."
    }
   0.breaker3([792,738],0,0,660)
    {
    Ctrl = "0"
    OPCUR = "0"
    ENAB = "0"
    CLVL = "0.0"
    View = "1"
    ViewB = "1"
    DisPQ = "1"
    NAME = "B4"
    NAMEA = "BRKA"
    NAMEB = "BRKB"
    NAMEC = "BRKC"
    ROFF = "1.0e6 [ohm]"
    RON = "0.1 [ohm]"
    PRER = "0.5 [ohm]"
    TDA = "0.0 [s]"
    TDB = "0.0 [s]"
    TDC = "0.0 [s]"
    TDRA = "0.05 [s]"
    TDRB = "0.05 [s]"
    TDRC = "0.05 [s]"
    PostIns = "0"
    TDBOA = "0.005"
    IBRA = "I4A"
    IBRB = "I4B"
    IBRC = "I4C"
    IBR0 = "I40"
    SBRA = "Br4A"
    SBRB = "Br4B"
    SBRC = "Br4C"
    BP = "P4"
    BQ = "Q4"
    BOpen1 = "0"
    BOpen2 = "0"
    BOpen3 = "0"
    P = "-0.001088 [MW]"
    Q = "-0.0001701 [MVAR]"
    }
   0.breaker3([306,738],4,0,670)
    {
    Ctrl = "0"
    OPCUR = "0"
    ENAB = "0"
    CLVL = "0.0"
    View = "1"
    ViewB = "1"
    DisPQ = "1"
    NAME = "B3"
    NAMEA = "BRKA"
    NAMEB = "BRKB"
    NAMEC = "BRKC"
    ROFF = "1.0e6 [ohm]"
    RON = "0.1 [ohm]"
    PRER = "0.5 [ohm]"
    TDA = "0.0 [s]"
    TDB = "0.0 [s]"
    TDC = "0.0 [s]"
    TDRA = "0.05 [s]"
    TDRB = "0.05 [s]"
    TDRC = "0.05 [s]"
    PostIns = "0"
    TDBOA = "0.005"
    IBRA = "I3A"
    IBRB = "I3B"
    IBRC = "I3C"
    IBR0 = "I30"
    SBRA = "Br3A"
    SBRB = "Br3B"
    SBRC = "Br3C"
    BP = "P3"
    BQ = "Q3"
    BOpen1 = "0"
    BOpen2 = "0"
    BOpen3 = "0"
    P = "0.005943 [MW]"
    Q = "0.4329 [MVAR]"
    }
   -Wire-([540,756],0,0,-1)
    {
    Vertex="0,0;0,-18"
    }
   0.multimeter([360,522],0,0,80)
    {
    MeasI = "0"
    MeasV = "1"
    MeasP = "0"
    MeasQ = "0"
    RMS = "1"
    MeasPh = "0"
    S = "1.0 [MVA]"
    BaseV = "1.0 [kV]"
    TS = "0.02 [s]"
    Freq = "60.0 [Hz]"
    Dis = "0"
    CurI = ""
    VolI = "V1"
    P = ""
    Q = ""
    Vrms = "V1rms"
    Ph = ""
    hide1 = "0"
    hide2 = "0"
    Pd = ""
    Qd = ""
    Vd = ""
    }
   0.multimeter([360,738],0,0,150)
    {
    MeasI = "0"
    MeasV = "1"
    MeasP = "0"
    MeasQ = "0"
    RMS = "1"
    MeasPh = "0"
    S = "1.0 [MVA]"
    BaseV = "1.0 [kV]"
    TS = "0.02 [s]"
    Freq = "60.0 [Hz]"
    Dis = "0"
    CurI = ""
    VolI = "V3"
    P = ""
    Q = ""
    Vrms = "V3rms"
    Ph = ""
    hide1 = "0"
    hide2 = "0"
    Pd = ""
    Qd = ""
    Vd = ""
    }
   0.multimeter([738,738],4,0,190)
    {
    MeasI = "0"
    MeasV = "1"
    MeasP = "0"
    MeasQ = "0"
    RMS = "1"
    MeasPh = "0"
    S = "1.0 [MVA]"
    BaseV = "1.0 [kV]"
    TS = "0.02 [s]"
    Freq = "60.0 [Hz]"
    Dis = "0"
    CurI = ""
    VolI = "V4"
    P = ""
    Q = ""
    Vrms = "V4rms"
    Ph = ""
    hide1 = "0"
    hide2 = "0"
    Pd = ""
    Qd = ""
    Vd = ""
    }
   0.multimeter([738,522],4,0,90)
    {
    MeasI = "0"
    MeasV = "1"
    MeasP = "0"
    MeasQ = "0"
    RMS = "1"
    MeasPh = "0"
    S = "1.0 [MVA]"
    BaseV = "1.0 [kV]"
    TS = "0.02 [s]"
    Freq = "60.0 [Hz]"
    Dis = "0"
    CurI = ""
    VolI = "V2"
    P = ""
    Q = ""
    Vrms = "V2rms"
    Ph = ""
    hide1 = "0"
    hide2 = "0"
    Pd = ""
    Qd = ""
    Vd = ""
    }
   -Wire-([1890,1188],0,0,-1)
    {
    Vertex="0,0;36,0"
    }
   0.datalabel([1890,1188],0,0,-1)
    {
    Name = "V1rms"
    }
   -Wire-([1890,1224],0,0,-1)
    {
    Vertex="0,0;36,0"
    }
   0.datalabel([1890,1224],0,0,-1)
    {
    Name = "V2rms"
    }
   -Wire-([1890,1260],0,0,-1)
    {
    Vertex="0,0;36,0"
    }
   0.datalabel([1890,1260],0,0,-1)
    {
    Name = "V3rms"
    }
   -Wire-([1890,1296],0,0,-1)
    {
    Vertex="0,0;36,0"
    }
   0.datalabel([1890,1296],0,0,-1)
    {
    Name = "V4rms"
    }
   -Divider-([36,1026],0)
    {
    Size(2340,0)
    3D = 1
    Color = 9
    Style = 0
    Weight = 2
    }
   -Divider-([1350,1026],0)
    {
    Size(0,-990)
    3D = 1
    Color = 9
    Style = 0
    Weight = 2
    }
   -Divider-([594,1530],0)
    {
    Size(0,-504)
    3D = 1
    Color = 9
    Style = 0
    Weight = 2
    }
   -Sticky-([648,36],0)
    {
    Name = ""
    Font = 1
    Bounds = 648,36,1044,144
    Alignment = 0
    Style = 0
    Arrow = 0
    Color = 0,15792890
    Text = "\
This case uses global substitutions.  To change between 50Hz/60Hz. select Global Substitutions (Ctrl-G).  In the pop-up window, change the value of f to the desired frequency.
"
    }
   }
  }
 }

